<?php
// load plugin details
$pluginConfig = pluginHelper::pluginSpecificConfiguration('stripe');
$settings = $pluginConfig['data']['plugin_settings'];
$settingsArr = json_decode($settings, true);

// create link to payment gateway
?>
<script src="https://checkout.stripe.com/checkout.js"></script>

<div style="text-align: center; padding: 3px;">
        <input type="hidden" name="days" value="<?php echo $days; ?>" />
        <?php
        if (isset($_REQUEST['i']))
        {
            echo '<input type="hidden" name="i" value="' . htmlentities($_REQUEST['i']) . '" />';
        }
        if (isset($_REQUEST['f']))
        {
            echo '<input type="hidden" name="f" value="' . htmlentities($_REQUEST['f']) . '" />';
        }
        ?>
		<input id="stripeButton<?php echo $days; ?>" type="image" src="<?php echo PLUGIN_WEB_ROOT; ?>/<?php echo $pluginConfig['data']['folder_name']; ?>/assets/img/payment_button.gif" title="Pay with Stripe" alt="Pay with Stripe" width="150" height="82" style="margin-left: -1px;"/>

    </form>
	
	<script>
	  var handler<?php echo $days; ?> = StripeCheckout.configure({
		key: '<?php echo $settingsArr['publishable_key']; ?>',
		token: function(token, args) {
			window.location = '<?php echo PLUGIN_WEB_ROOT; ?>/<?php echo $pluginConfig['data']['folder_name']; ?>/site/_payment_ipn.php?charge_days='+<?php echo $days; ?>+'&token='+token.id+'&f=<?php if (isset($_REQUEST['f']))
        {
            echo htmlentities($_REQUEST['f']);
        } ?>';
		}
	  });

	  document.getElementById('stripeButton<?php echo $days; ?>').addEventListener('click', function(e) {
        <?php
        $Auth = Auth::getAuth();
        if($Auth->loggedIn() == false)
        {
            ?>
            window.location = '<?php echo WEB_ROOT; ?>/register.<?php echo SITE_CONFIG_PAGE_EXTENSION; ?>?from=stripe&days=<?php echo $days; ?>';
            <?php
        }
        else
        {
        ?>
		// Open Checkout with further options
		handler<?php echo $days; ?>.open({
		  name: '<?php echo SITE_CONFIG_SITE_NAME; ?>',
		  description: 'Upgrade for <?php echo SITE_CONFIG_COST_CURRENCY_SYMBOL; ?><?php echo str_replace(",", "", constant('SITE_CONFIG_COST_FOR_' . $days . '_DAYS_PREMIUM')); ?> every <?php echo $days; ?> days',
		  amount: <?php echo str_replace(",", "", constant('SITE_CONFIG_COST_FOR_' . $days . '_DAYS_PREMIUM')) * 100; ?>
		});
        <?php
        }
        ?>
		e.preventDefault();
	  });
	  
	  <?php
      if((isset($_REQUEST['from'])) && (isset($_REQUEST['days'])))
      {
          if(($_REQUEST['from'] == 'stripe') && ($_REQUEST['days'] == $days))
          {
              ?>
              $('#stripeButton<?php echo $days; ?>').click();
              <?php
          }
      }
      ?>
	</script>

</div>