<?php
// initial constants
define('ADMIN_SELECTED_PAGE', 'plugins');
define('ADMIN_SELECTED_SUB_PAGE', 'plugin_manage');

// includes and security
include_once('../../../core/includes/master.inc.php');
include_once(DOC_ROOT . '/' . ADMIN_FOLDER_NAME . '/_local_auth.inc.php');

// load plugin details
$pluginId = (int) $_REQUEST['id'];
$plugin   = $db->getRow("SELECT * FROM plugin WHERE id = " . (int) $pluginId . " LIMIT 1");
if (!$plugin)
{
    adminFunctions::redirect(ADMIN_WEB_ROOT . '/plugin_manage.php?error=' . urlencode('There was a problem loading the plugin details.'));
}
define('ADMIN_PAGE_TITLE', $plugin['plugin_name'] . ' Plugin Settings');

// prepare variables
$plugin_enabled = (int) $plugin['plugin_enabled'];
$secret_key   = '';
$publishable_key = '';

// load existing settings
if (strlen($plugin['plugin_settings']))
{
    $plugin_settings = json_decode($plugin['plugin_settings'], true);
    if ($plugin_settings)
    {
        $secret_key = $plugin_settings['secret_key'];
		$publishable_key = $plugin_settings['publishable_key'];
        if (_CONFIG_DEMO_MODE == true)
        {
            $secret_key = '[hidden]';
            $publishable_key = '[hidden]';
        }
    }
}

// handle page submissions
if (isset($_REQUEST['submitted']))
{
    // get variables
    $plugin_enabled = (int) $_REQUEST['plugin_enabled'];
    $plugin_enabled = $plugin_enabled != 1 ? 0 : 1;
    $secret_key   = trim($_REQUEST['secret_key']);
	$publishable_key   = trim($_REQUEST['publishable_key']);

    // validate submission
    if (_CONFIG_DEMO_MODE == true)
    {
        adminFunctions::setError(adminFunctions::t("no_changes_in_demo_mode"));
    }
    elseif (strlen($secret_key) == 0)
    {
        adminFunctions::setError(adminFunctions::t("please_enter_your_secret_key", "Please enter your Stripe API secret key."));
    }

    // update the settings
    if (adminFunctions::isErrors() == false)
    {
        // compile new settings
        $settingsArr                 = array();
        $settingsArr['secret_key'] = $secret_key;
		$settingsArr['publishable_key'] = $publishable_key;
        $settings                    = json_encode($settingsArr);

        // update the user
        $dbUpdate                  = new DBObject("plugin", array("plugin_enabled", "plugin_settings"), 'id');
        $dbUpdate->plugin_enabled  = $plugin_enabled;
        $dbUpdate->plugin_settings = $settings;
        $dbUpdate->id              = $pluginId;
        $dbUpdate->update();

        adminFunctions::redirect(ADMIN_WEB_ROOT . '/plugin_manage.php?se=1');
    }
}

// page header
include_once(ADMIN_ROOT . '/_header.inc.php');
?>

<script>
    $(function() {
        // formvalidator
        $("#userForm").validationEngine();
    });
</script>

<div class="row clearfix">
    <div class="col_12">
        <div class="sectionLargeIcon" style="background: url(../assets/img/icons/128px.png) no-repeat;"></div>
        <div class="widget clearfix">
            <h2>Plugin Settings</h2>
            <div class="widget_inside">
                <?php echo adminFunctions::compileNotifications(); ?>
                <form method="POST" action="settings.php" name="pluginForm" id="pluginForm" autocomplete="off">
                    <div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Plugin State</h3>
                            <p>Whether the Stripe payment option for upgrades is enabled.</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <label>Plugin Enabled:</label>
                                    <div class="input">
                                        <select name="plugin_enabled" id="plugin_enabled" class="medium validate[required]">
                                            <?php
                                            $enabledOptions = array(0 => 'No', 1 => 'Yes');
                                            foreach ($enabledOptions AS $k => $enabledOption)
                                            {
                                                echo '<option value="' . $k . '"';
                                                if ($plugin_enabled == $k)
                                                {
                                                    echo ' SELECTED';
                                                }
                                                echo '>' . $enabledOption . '</option>';
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="clearfix col_12">
                        <div class="col_4">
                            <h3>Stripe Settings</h3>
                            <p>Your Stripe API details.</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <label>Secret Key:</label>
                                    <div class="input"><input id="secret_key" name="secret_key" type="text" class="large validate[required]" value="<?php echo adminFunctions::makeSafe($secret_key); ?>"/></div>
                                </div>
								<div class="clearfix">
                                    <label>Publishable Key:</label>
                                    <div class="input"><input id="publishable_key" name="publishable_key" type="text" class="large validate[required]" value="<?php echo adminFunctions::makeSafe($publishable_key); ?>"/></div>
                                </div>
                                <div class="clearfix alt-highlight">
                                    <label>Subscriptions:</label>
                                    <div class="input">
                                        In order to enable subscriptions you need to create the 5 plans in Stripe itself. Login<br/>and go to plans on the left and add each, setting the price, currency (USD) and<br/>period. Important: Make sure each plan id is in the format 'plan[days]'. So 'plan30',<br/>'plan90', 'plan180' etc. See <a href="../assets/plans.jpg" target="_blank">here for an example</a> screenshot.
                                    </div>
                                </div>
                                <div class="clearfix">
                                    <label>Web Hook:</label>
                                    <div class="input">
                                        So that rebills automatically extend paid accounts, you need to setup a web hook in<br/>Stripe to call back your site. The url to use as the web hook is:<br/><br/>
                                        <?php echo WEB_ROOT; ?>/plugins/stripe/site/subscription_web_hook.php
                                        <br/><br/>
                                        See <a href="../assets/webhook.jpg" target="_blank">here for an example</a> screenshot.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="clearfix col_12">
                        <div class="col_4 adminResponsiveHide">&nbsp;</div>
                        <div class="col_8 last">
                            <div class="clearfix">
                                <div class="input no-label">
                                    <input type="submit" value="Submit" class="button blue">
                                    <input type="reset" value="Reset" class="button grey">
                                </div>
                            </div>
                        </div>
                    </div>

                    <input name="submitted" type="hidden" value="1"/>
                    <input name="id" type="hidden" value="<?php echo $pluginId; ?>"/>
                </form>
            </div>
        </div>   
    </div>
</div>

<?php
include_once(ADMIN_ROOT . '/_footer.inc.php');
?>