<?php

require_once('../../../core/includes/master.inc.php');

// load plugin details
$pluginConfig = pluginHelper::pluginSpecificConfiguration('paypal');
$pluginSettings = $pluginConfig['data']['plugin_settings'];
$paypalEmail = '';
$enable_sandbox_mode = 0;
$enable_subscriptions = 0;
if(strlen($pluginSettings))
{
    $pluginSettingsArr = json_decode($pluginSettings, true);
    $paypalEmail = $pluginSettingsArr['paypal_email'];
    $enable_sandbox_mode = (int) $pluginSettingsArr['enable_sandbox_mode'];
    $enable_subscriptions = (int) $pluginSettingsArr['enable_subscriptions'];
}

if(!isset($_REQUEST['user_level_pricing_id']))
{
    coreFunctions::redirect(WEB_ROOT . '/index.html');
}

// require login
if(!isset($_REQUEST['i']))
{
    $Auth->requireUser(WEB_ROOT . '/register.' . SITE_CONFIG_PAGE_EXTENSION);
    $userId = $Auth->id;
    $username = $Auth->username;
    $userEmail = $Auth->email;
}
else
{
    $user = UserPeer::loadUserByIdentifier($_REQUEST['i']);
    if(!$user)
    {
        die('User not found!');
    }

    $userId = $user->id;
    $username = $user->username;
    $userEmail = $user->email;
}

$user_level_pricing_id = (int) $_REQUEST['user_level_pricing_id'];

$fileId = null;
if(isset($_REQUEST['f']))
{
    $file = file::loadByShortUrl($_REQUEST['f']);
    if($file)
    {
        $fileId = $file->id;
    }
}

// create order entry
$order = OrderPeer::createByPackageId($userId, $user_level_pricing_id, $fileId);
if($order)
{
    // redirect to the payment gateway
    $baseUrl = "https://www.paypal.com/cgi-bin/webscr";
    if($enable_sandbox_mode == 1)
    {
        $baseUrl = "https://www.sandbox.paypal.com/cgi-bin/webscr";
    }
    
    // for subscriptions
    if($enable_subscriptions == 1)
    {
        // load up pricing data for the subscription
        $pricingData = $db->getRow('SELECT pricing_label, period, price FROM user_level_pricing WHERE id = '.(int)$user_level_pricing_id.' LIMIT 1');
        if (!$pricingData)
        {
            coreFunctions::redirect(WEB_ROOT . '/index.html');
        }

        $periodType = substr($pricingData['period'], strlen($pricingData['period'])-1, 1);
        $periodValue = substr($pricingData['period'], 0, strlen($pricingData['period'])-1);
        $paypalUrl = $baseUrl . '?cmd=_xclick-subscriptions&notify_url=' . urlencode(PLUGIN_WEB_ROOT . '/' . $pluginConfig['data']['folder_name'] . '/site/_payment_ipn.php') . '&email=' . urlencode($userEmail) . '&return=' . urlencode(WEB_ROOT . '/payment_complete.' . SITE_CONFIG_PAGE_EXTENSION) . '&business=' . urlencode($paypalEmail) . '&item_name=' . urlencode($order->description) . '&item_number=1&a3=' . urlencode($order->amount) . '&no_shipping=2&no_note=1&currency_code=' . SITE_CONFIG_COST_CURRENCY_CODE . '&lc=' . substr(SITE_CONFIG_COST_CURRENCY_CODE, 0, 2) . '&bn=PP%2dBuyNowBF&charset=UTF%2d8&custom=' . $order->payment_hash.'&t3='.$periodType.'&p3='.(int)$periodValue.'&sra=1';
    }
    // for non subscriptions
    else
    {
        $paypalUrl = $baseUrl . '?cmd=_xclick&notify_url=' . urlencode(PLUGIN_WEB_ROOT . '/' . $pluginConfig['data']['folder_name'] . '/site/_payment_ipn.php') . '&email=' . urlencode($userEmail) . '&return=' . urlencode(WEB_ROOT . '/payment_complete.' . SITE_CONFIG_PAGE_EXTENSION) . '&business=' . urlencode($paypalEmail) . '&item_name=' . urlencode($order->description) . '&item_number=1&amount=' . urlencode($order->amount) . '&no_shipping=2&no_note=1&currency_code=' . SITE_CONFIG_COST_CURRENCY_CODE . '&lc=' . substr(SITE_CONFIG_COST_CURRENCY_CODE, 0, 2) . '&bn=PP%2dBuyNowBF&charset=UTF%2d8&custom=' . $order->payment_hash;
    }
    coreFunctions::redirect($paypalUrl);
}
