<?php

include('functions.php');

$pluginConfig = pluginHelper::pluginSpecificConfiguration('linkchecker');
$plugin_settings = json_decode($pluginConfig['data']['plugin_settings'], true);
if ($plugin_settings)
{
	// is the plugin enabled?
	$plugin_enabled	= $pluginConfig['data']['plugin_enabled'];
	$plugin_folder	= $pluginConfig['data']['folder_name'];

	$linksAccess	= $plugin_settings['linksAccess'];
	$linksMax		= $plugin_settings['linksMax'];
	$linksMessage	= $plugin_settings['linksMessage'];
}
	$Auth = Auth::getAuth();
	$db = Database::getDatabase();

// Plugin Enabled?
if($plugin_enabled == '1')
{
	?>
	<script type="text/javascript">
	$(document).ready(function(){
		$('#lcsubmit').click(function(){
			showValues(); 
			return false;
		});
		
		$(function() {
			$('#clinks').bind('submit',function(){
				showValues(); 
				return false; 
			});
		});		
		function showValues() {
			$.post('plugins/<?php echo $plugin_folder; ?>/includes/links.php', { tocheck: clinks.links.value },		
			function(result){
				//alert(result);
				$('#lc-results').html(result).show();
			});
		}		
	});
	</script>
	<!-- Link Checker -->
	<div id="linkChecker">
		<div class="urlUploadMain ui-corner-all">
			<div id="fileUploadBadge" class="fileUploadBadge"></div>
				<div class="urlUploadMainInternal contentPageWrapper">
					<!-- url uploader -->
					<div>
						<div id="urlFileUploader">
							<form name="clinks" id="clinks" action="" method="post">
								<div class="initialUploadText" style="text-decoration:none;">
									<div class="uploadText"><h2><?php echo t('check_links', 'Check Links'); ?>:</h2></div>
									<div class="clearLeft"><!-- --></div>					

		<?php
		// Switch between who has access
		switch ($linksAccess)
		{
			case '10':
				// Admin Only
				if($Auth->hasAccessLevel(10))
				{
					echo '<p>'.t('linkchecker_description_pre', 'You can use this form to check up to '). $linksMax . t('linkchecker_description_app', ' links to see if they are active or have been deleted.<br/>(One link per line)').'.</p>';
					echo '<textarea rows="12" cols="15" id="links" name="links" style="width:580px; height:200px;"></textarea><br />';
					echo '<input id="lcsubmit" type="submit" name="submit" value="'.t("link_checker_button", "check links").'" class="submitInput" />';
				}
				else
				{
					echo $linksMessage;
				}
			break;
			case '2':
				// Admin & Paid only
				if($Auth->hasAccessLevel(2))
				{
					echo '<p>'.t('linkchecker_description_pre', 'You can use this form to check up to '). $linksMax . t('linkchecker_description_app', ' links to see if they are active or have been deleted.<br/>(One link per line)').'.</p>';
					echo '<textarea rows="12" cols="15" id="links" name="links" style="width:580px; height:200px;"></textarea><br />'; 
					echo '<input id="lcsubmit" type="submit" name="submit" value="'.t("link_checker_button", "check links").'" class="submitInput" />';
				}
				else
				{
					echo $linksMessage;
				}
			break;
			case '1':
				// Logged in users only
				if($Auth->loggedIn() == true)
				{
					echo '<p>'.t('linkchecker_description_pre', 'You can use this form to check up to '). $linksMax . t('linkchecker_description_app', ' links to see if they are active or have been deleted.<br/>(One link per line)').'.</p>';
					echo '<textarea rows="12" cols="15" id="links" name="links" style="width:580px; height:200px;"></textarea><br />'; 
					echo '<input id="lcsubmit" type="submit" name="submit" value="'.t("link_checker_button", "check links").'" class="submitInput" />';
				}
				else
				{
					echo $linksMessage;
				}
			break;
			case '0':
				// Everyone
				echo '<p>'.t('linkchecker_description_pre', 'You can use this form to check up to '). $linksMax . t('linkchecker_description_app', ' links to see if they are active or have been deleted.<br/>(One link per line)').'.</p>';
				echo '<textarea rows="12" cols="15" id="links" name="links" style="width:580px; height:200px;"></textarea><br />';
				echo '<input id="lcsubmit" type="submit" name="submit" value="'.t("link_checker_button", "check links").'" class="submitInput" />';
				break;
		}
		echo '</form>';
		echo '<div class="clear">&nbsp;</div>
				<div id="lc-results"></div>';
		echo '</div>
			  </div>
			  <div class="clear"><!-- --></div>
			  </div>
			  <div class="clear"><!-- --></div>
			  </div>
			  </div>
			  </div>
			  <!-- Link Checker -->';
}
?>