<?php
// local template functions
require_once(SITE_TEMPLATES_PATH . '/partial/_template_functions.inc.php');

// load theme functions
$themeObj = themeHelper::getLoadedInstance();
$themeSkin = $themeObj->getThemeSkin();

// top navigation
require_once(SITE_TEMPLATES_PATH . '/partial/_navigation_header.inc.php');

// per page options
$perPageOptions = array(15, 30, 50, 100, 250);
$defaultPerPage = 100;

// load all files
$sQL         = "SELECT COUNT(id) AS total, SUM(fileSize) AS totalFilesize, IF(statusId=1,'active','inactive') AS status FROM file WHERE userId = " . (int) $Auth->id . " GROUP BY IF(statusId=1,'active','inactive')";
$totalData   = $db->getRows($sQL);
$totalActiveFileSize = 0;
foreach($totalData AS $totalDataItem)
{
	if($totalDataItem['status'] == 'active')
	{
		$totalActive = (int)$totalDataItem['total'];
		$totalActiveFileSize = (int)$totalDataItem['totalFilesize'];
	}
	else
	{
		$totalTrash = (int)$totalDataItem['total'];
	}
}

// account stats
$totalFileStorage    = UserPeer::getMaxFileStorage($Auth->id);
$storagePercentage   = 0;
if (($totalActiveFileSize > 0) && ($totalFileStorage > 0))
{
    $storagePercentage = ($totalActiveFileSize / $totalFileStorage) * 100;
    if ($storagePercentage < 1)
    {
        $storagePercentage = 1;
    }
    else
    {
        $storagePercentage = floor($storagePercentage);
    }
}

// header top
require_once(SITE_TEMPLATES_PATH . '/partial/_header_file_manager_top.inc.php');
?>
	
<body class="sb-left">
<!--============= start main area -->

<!-- APP ASIDE ==========-->
<aside id="app-aside" class="app-aside left light">
	<header class="aside-header">
		<div class="animated">
			<a href="index.html" id="app-brand" class="app-brand">
				<span id="brand-icon" class="brand-icon"><i class="fa fa-gg"></i></span>
				<span id="brand-name" class="brand-icon foldable">SV-es Load</span>
			</a>
		</div>
	</header><!-- #sidebar-header -->
	
	<div class="aside-user">
		<!-- aside-user -->
		<div class="media">
			<div class="media-left">
				<div class="avatar avatar-md avatar-circle">
					<a href="javascript:void(0)"><img class="img-responsive" src="../assets/images/221.jpg" alt="avatar"/></a>
				</div><!-- .avatar -->
			</div>
			<div class="media-body">
				<div class="foldable">
					<h5><a href="javascript:void(0)" class="username">John Doe</a></h5>
					<ul>
						<li class="dropdown">
							<a href="javascript:void(0)" class="dropdown-toggle usertitle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
								<small>Web Developer</small>
								<span class="caret"></span>
							</a>
							<ul class="dropdown-menu animated flipInY">
								<li>
									<a class="text-color" href="http://envato.rathemes.com/index.html">
										<span class="m-r-xs"><i class="fa fa-home"></i></span>
										<span>Home</span>
									</a>
								</li>
								<li>
									<a class="text-color" href="profile.html">
										<span class="m-r-xs"><i class="fa fa-user"></i></span>
										<span>Profile</span>
									</a>
								</li>
								<li>
									<a class="text-color" href="settings.html">
										<span class="m-r-xs"><i class="fa fa-gear"></i></span>
										<span>Settings</span>
									</a>
								</li>
								<li role="separator" class="divider"></li>
								<li>
									<a class="text-color" href="logout.html">
										<span class="m-r-xs"><i class="fa fa-power-off"></i></span>
										<span>Home</span>
									</a>
								</li>
							</ul>
						</li>
					</ul>
				</div>
			</div>
		</div>
		<!-- /aside-user -->
	</div><!-- #aside-user -->

	<div class="aside-scroll">
		<div id="aside-scroll-inner" class="aside-scroll-inner">
			<ul class="aside-menu aside-left-menu">
				<li class="menu-item has-submenu">
					<a href="javascript:void(0)" class="menu-link submenu-toggle">
						<span class="menu-icon"><i class="zmdi zmdi-view-dashboard zmdi-hc-lg"></i></span>
						<span class="menu-text foldable">Dashboard</span>
						<span class="menu-caret foldable"><i class="zmdi zmdi-hc-sm zmdi-chevron-right"></i></span>
					</a>
					<ul class="submenu">
						<li><a href="index.html">Dashboard 1</a></li>
						<li><a href="dashboard.2.html">Dashboard 2</a></li>
					</ul>
				</li><!-- .menu-item -->
				
				<li class="menu-item has-submenu">
					<a href="javascript:void(0)" class="menu-link submenu-toggle">
						<span class="menu-icon"><i class="zmdi zmdi-layers zmdi-hc-lg"></i></span>
						<span class="menu-text foldable">Layouts</span>
						<span class="menu-caret foldable"><i class="zmdi zmdi-hc-sm zmdi-chevron-right"></i></span>
					</a>
					<ul class="submenu">
						<li><a href="index.html">Default</a></li>
						<li><a href="http://envato.rathemes.com/infinity/topbar/index.html">Topbar</a></li>
					</ul>
				</li><!-- .menu-item -->

				<li class="menu-item has-submenu">
					<a href="javascript:void(0)" class="menu-link submenu-toggle">
						<span class="menu-icon"><i class="zmdi zmdi-puzzle-piece zmdi-hc-lg"></i></span>
						<span class="menu-text foldable">UI Kit</span>
						<span class="menu-caret foldable"><i class="zmdi zmdi-hc-sm zmdi-chevron-right"></i></span>
					</a>
					<ul class="submenu">
						<li><a href="buttons.html">Buttons</a></li>
						<li><a href="alerts.html">Alerts</a></li>
						<li><a href="panels.html">Panels</a></li>
						<li><a href="lists.html">Lists</a></li>
						<li><a href="icons.html">Icons</a></li>
						<li><a href="media.html">Media</a></li>
						<li><a href="widgets.html">Widgets</a></li>
						<li><a href="tabs.html">Tabs &amp; Accordions</a></li>
						<li><a href="progress.html">Progress</a></li>
					</ul>
				</li><!-- .menu-item -->

				<li class="menu-item has-submenu">
					<a href="javascript:void(0)" class="menu-link submenu-toggle">
						<span class="menu-icon"><i class="zmdi zmdi-inbox zmdi-hc-lg"></i></span>
						<span class="menu-text foldable">Mail Box</span>
						<span class="menu-caret foldable"><i class="zmdi zmdi-hc-sm zmdi-chevron-right"></i></span>
					</a>
					<ul class="submenu">
						<li><a href="inbox.html">Inbox <span class="badge bg-primary menu-label">12</span></a></li>
						<li><a href="compose.html">Compose</a></li>
					</ul>
				</li><!-- .menu-item -->
				
				<li class="menu-item">
					<a href="search.web.html" class="menu-link">
						<span class="menu-icon"><i class="zmdi zmdi-search zmdi-hc-lg"></i></span>
						<span class="menu-text foldable">Search</span>
					</a>
				</li><!-- .menu-item -->

				<li class="menu-item has-submenu">
					<a href="javascript:void(0)" class="menu-link submenu-toggle">
						<span class="menu-icon"><i class="zmdi zmdi-pages zmdi-hc-lg"></i></span>
						<span class="menu-text foldable">Pages</span>
						<span class="menu-caret foldable"><i class="zmdi zmdi-hc-sm zmdi-chevron-right"></i></span>
					</a>
					<ul class="submenu">
						<li><a href="profile.html">Profile</a></li>
						<li><a href="price.html">Prices</a></li>
						<li><a href="invoice.html">Invoice</a></li>
						<li><a href="gallery.1.html">Gallery</a></li>
						<li><a href="gallery.2.html">Gallery 2</a></li>
						<li><a href="support.html">FAQ</a></li>
					</ul>
				</li><!-- .menu-item -->

				<li class="menu-item has-submenu">
					<a href="javascript:void(0)" class="menu-link submenu-toggle">
						<span class="menu-icon"><i class="zmdi zmdi-check zmdi-hc-lg"></i></span>
						<span class="menu-text foldable">Forms</span>
						<span class="menu-caret foldable"><i class="zmdi zmdi-hc-sm zmdi-chevron-right"></i></span>
					</a>
					<ul class="submenu">
						<li><a href="form.layouts.html">Form Layouts</a></li>
						<li><a href="form.elements.html">Form Elements</a></li>
						<li><a href="form.custom.html">Customized Elements</a></li>
						<li><a href="form.plugins.html">Form Plugins</a></li>
						<li><a href="file-upload.html">File Upload</a></li>
						<li><a href="form.datetime.html">DateTime Pickers</a></li>
						<li><a href="editors.html">Editors</a></li>
					</ul>
				</li><!-- .menu-item -->

				<li class="menu-item has-submenu">
					<a href="javascript:void(0)" class="menu-link submenu-toggle">
						<span class="menu-icon"><i class="zmdi zmdi-storage zmdi-hc-lg"></i></span>
						<span class="menu-text foldable">Tables</span>
						<span class="menu-caret foldable"><i class="zmdi zmdi-hc-sm zmdi-chevron-right"></i></span>
					</a>
					<ul class="submenu">
						<li><a href="tables.basic.html">Basic Tables</a></li>
						<li><a href="datatables.html">DataTables</a></li>
					</ul>
				</li><!-- .menu-item -->

				<li class="menu-item has-submenu">
					<a href="javascript:void(0)" class="menu-link submenu-toggle">
						<span class="menu-icon"><i class="zmdi zmdi-chart zmdi-hc-lg"></i></span>
						<span class="menu-text foldable">Charts</span>
						<span class="menu-caret foldable"><i class="zmdi zmdi-hc-sm zmdi-chevron-right"></i></span>
					</a>
					<ul class="submenu">
						<li><a href="charts.flot.html">Flot Charts</a></li>
						<li><a href="echarts.bar.html">Bar echarts</a></li>
						<li><a href="echarts.pie.html">Pie echarts</a></li>
						<li><a href="echarts.line.html">Line echarts</a></li>
						<li><a href="echarts.map.html">Map echarts</a></li>
						<li><a href="echarts.scatter.html">Scatter echarts</a></li>
						<li><a href="echarts.custom.html">Custom echarts</a></li>
					</ul>
				</li><!-- .menu-item -->

				<li class="menu-item has-submenu">
					<a href="javascript:void(0)" class="menu-link submenu-toggle">
						<span class="menu-icon"><i class="zmdi zmdi-pin zmdi-hc-lg"></i></span>
						<span class="menu-text foldable">Maps</span>
						<span class="menu-caret foldable"><i class="zmdi zmdi-hc-sm zmdi-chevron-right"></i></span>
					</a>
					<ul class="submenu">
						<li><a href="map-google.html">Google Maps</a></li>
						<li><a href="map-vector.html">Vector Maps</a></li>
					</ul>
				</li><!-- .menu-item -->

				<li class="menu-item has-submenu">
					<a href="javascript:void(0)" class="menu-link submenu-toggle">
						<span class="menu-icon"><i class="zmdi zmdi-apps zmdi-hc-lg"></i></span>
						<span class="menu-text foldable">Apps</span>
						<span class="menu-caret foldable"><i class="zmdi zmdi-hc-sm zmdi-chevron-right"></i></span>
					</a>
					<ul class="submenu">
						<li><a href="calendar.html">Calendar</a></li>
						<li><a href="contacts.html">Contacts</a></li>
					</ul>
				</li><!-- .menu-item -->

				<li class="menu-item has-submenu">
					<a href="javascript:void(0)" class="menu-link submenu-toggle">
						<span class="menu-icon"><i class="zmdi zmdi-plus zmdi-hc-lg"></i></span>
						<span class="menu-text foldable">Extras</span>
						<span class="menu-caret foldable"><i class="zmdi zmdi-hc-sm zmdi-chevron-right"></i></span>
					</a>
					<ul class="submenu">
						<li><a href="login.html">Login</a></li>
						<li><a href="signup.html">Sign Up</a></li>
						<li><a href="password-forget.html">Reset Password</a></li>
						<li><a href="unlock.html">Unlock Screen</a></li>
						<li><a href="404.html">404 Error</a></li>
					</ul>
				</li><!-- .menu-item -->
			</ul>
			<hr>
			<footer id="aside-footer">
				<ul class="aside-menu aside-left-menu">
					<li class="menu-item">
						<a href="documentation.html" class="menu-link">
							<span class="menu-icon"><i class="zmdi zmdi-file-text zmdi-hc-lg"></i></span>
							<span class="menu-text foldable">Documentation</span>
						</a>
					</li><!-- .menu-item -->

					<li class="menu-item">
						<a href="javascript:void(0)" class="menu-link">
							<span class="menu-icon"><i class="zmdi zmdi-settings zmdi-hc-lg"></i></span>
							<span class="menu-text foldable">Settings</span>
						</a>
					</li><!-- .menu-item -->
					
					<li class="menu-item">
						<a href="javascript:void(0)" class="menu-link">
							<span class="menu-icon"><i class="zmdi zmdi-language-javascript zmdi-hc-lg"></i></span>
							<span class="menu-text foldable">Angular Version</span>
						</a>
					</li><!-- .menu-item -->
				</ul>
			</footer><!-- #sidebar-footer -->
		</div><!-- .aside-scroll-inner -->
	</div><!-- #aside-scroll -->
</aside>
<!--========== END app aside -->

<!-- APP NAVBAR ==========-->
<nav id="app-navbar" class="app-navbar p-l-lg p-r-md primary">
	<div id="navbar-header" class="pull-left">
		<button id="aside-fold" class="hamburger visible-lg-inline-block hamburger--arrowalt is-active js-hamburger" type="button">
			<span class="hamburger-box">
				<span class="hamburger-inner"></span>
			</span>
		</button>
		<button id="aside-toggle" class="hamburger hidden-lg hamburger--spin js-hamburger" type="button">
			<span class="hamburger-box">
				<span class="hamburger-inner"></span>
			</span>
		</button>
		<h5 id="page-title" class="visible-md-inline-block visible-lg-inline-block m-l-md">Dashboard</h5>
	</div>

	<div>
		<ul id="top-nav" class="pull-right">
			<li class="nav-item dropdown">
				<a href="javascript:void(0)" id="navbar-search-open" class="navbar-search-open">
					<i class="zmdi zmdi-hc-lg zmdi-search"></i>
				</a>
			</li>
			<li class="nav-item dropdown">
				<a href="javascript:void(0)" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false"><i class="zmdi zmdi-hc-lg zmdi-notifications"></i></a>
				<div class="media-group dropdown-menu animated flipInY">
					<a href="javascript:void(0)" class="media-group-item">
						<div class="media">
							<div class="media-left">
								<div class="avatar avatar-xs avatar-circle">
									<img src="../assets/images/221.jpg" alt="">
									<i class="status status-online"></i>
								</div>
							</div>
							<div class="media-body">
								<h5 class="media-heading">John Doe</h5>
								<small class="media-meta">Active now</small>
							</div>
						</div>
					</a><!-- .media-group-item -->

					<a href="javascript:void(0)" class="media-group-item">
						<div class="media">
							<div class="media-left">
								<div class="avatar avatar-xs avatar-circle">
									<img src="../assets/images/205.jpg" alt="">
									<i class="status status-offline"></i>
								</div>
							</div>
							<div class="media-body">
								<h5 class="media-heading">John Doe</h5>
								<small class="media-meta">2 hours ago</small>
							</div>
						</div>
					</a><!-- .media-group-item -->

					<a href="javascript:void(0)" class="media-group-item">
						<div class="media">
							<div class="media-left">
								<div class="avatar avatar-xs avatar-circle">
									<img src="../assets/images/207.jpg" alt="">
									<i class="status status-away"></i>
								</div>
							</div>
							<div class="media-body">
								<h5 class="media-heading">Sara Smith</h5>
								<small class="media-meta">idle 5 min ago</small>
							</div>
						</div>
					</a><!-- .media-group-item -->

					<a href="javascript:void(0)" class="media-group-item">
						<div class="media">
							<div class="media-left">
								<div class="avatar avatar-xs avatar-circle">
									<img src="../assets/images/211.jpg" alt="">
									<i class="status status-away"></i>
								</div>
							</div>
							<div class="media-body">
								<h5 class="media-heading">Donia Dyab</h5>
								<small class="media-meta">idle 5 min ago</small>
							</div>
						</div>
					</a><!-- .media-group-item -->
				</div>
			</li>
			<li class="nav-item dropdown">
				<a href="javascript:void(0)" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false"><i class="zmdi zmdi-hc-lg zmdi-settings"></i></a>
				<ul class="dropdown-menu animated flipInY">
					<li><a href="javascript:void(0)"><i class="zmdi m-r-md zmdi-hc-lg zmdi-account-box"></i>My Profile</a></li>
					<li><a href="javascript:void(0)"><i class="zmdi m-r-md zmdi-hc-lg zmdi-balance-wallet"></i>Balance</a></li>
					<li><a href="javascript:void(0)"><i class="zmdi m-r-md zmdi-hc-lg zmdi-phone-msg"></i>Connection<span class="label _bgtext-primary">3</span></a></li>
					<li><a href="javascript:void(0)"><i class="zmdi m-r-md zmdi-hc-lg zmdi-info"></i>privacy</a></li>
				</ul>
			</li>
			
		</ul>
	</div>

	<!-- navbar search -->
	<div id="navbar-search" class="navbar-search">
		<form action="#">
			<span class="search-icon"><i class="fa fa-search"></i></span>
			<input class="search-field" type="search" placeholder="search..."/>
		</form>
		<button id="search-close" class="search-close">
			<i class="fa fa-close"></i>
		</button>
	</div><!-- END navbar search -->
</nav>
<!--========== END app navbar -->

