<?php

error_reporting(E_ALL | E_STRICT);

/* setup includes */
require_once('../../../core/includes/master.inc.php');

// log
log::breakInLogFile();
log::info('Remote upload request to urlUploadHandler.php: ' . http_build_query($_REQUEST));

// no caching
header('Pragma: no-cache');
header('Cache-Control: private, no-cache');

// get url
$url   = !empty($_REQUEST["url"]) && preg_match("|^http(s)?://.+$|", stripslashes($_REQUEST["url"])) ? stripslashes($_REQUEST["url"]) : null;
$rowId = (int) $_REQUEST['rowId'];

// process csaKeys and authenticate user
$csaKey1 = trim($_REQUEST['csaKey1']);
$csaKey2 = trim($_REQUEST['csaKey2']);
if(strlen($csaKey1) && strlen($csaKey2))
{
    crossSiteAction::setAuthFromKeys($csaKey1, $csaKey2, false);
}

// double check user is logged in if required
$Auth = Auth::getAuth();
$userId = null;
if ($Auth->loggedIn())
{
    $userId = $Auth->id;
}

// start uploader class
$upload_handler  = new uploader(array(
    'folder_id'=>(int)$_REQUEST['folderId'],
    'user_id'=>(int) $userId,
));
$fileUploadError = null;

// double check user is logged in if required
$Auth = Auth::getAuth();

if (UserPeer::getAllowedToUpload() == false)
{
    $fileUploadError = coreFunctions::createUploadError(t('unavailable', 'Unavailable.'), t('uploading_has_been_disabled', 'Uploading has been disabled.'));
}

// check for banned ip
$bannedIP = bannedIP::getBannedType();
if (($fileUploadError === null) && (strtolower($bannedIP) == "uploading"))
{
    $fileUploadError = coreFunctions::createUploadError(t('unavailable', 'Unavailable.'), t('uploading_has_been_disabled', 'Uploading has been disabled.'));
}

// check that the user has not reached their max permitted uploads
$fileRemaining = UserPeer::getRemainingFilesToday();
if (($fileUploadError === null) && ($fileRemaining == 0))
{
    $fileUploadError = coreFunctions::createUploadError(t('max_uploads_reached', 'Max uploads reached.'), t('reached_maximum_uploads', 'You have reached the maximum permitted uploads for today.'));
}

// check the user hasn't reached the maximum storage on their account
if (($fileUploadError === null) && ((UserPeer::getAvailableFileStorage($Auth->id) !== NULL) && (UserPeer::getAvailableFileStorage($Auth->id) <= 0)))
{
    $fileUploadError = coreFunctions::createUploadError(t('file_upload_space_full', 'File upload space full.'), t('file_upload_space_full_text', 'Upload storage full, please delete some active files and try again.'));
}

// on error
if ($fileUploadError !== null)
{
    $fileUploadError          = json_decode($fileUploadError, true);
    $fileUploadError          = $fileUploadError[0];
    $fileUploadError['rowId'] = $rowId;
    // allow sub-domains for remote file servers
    echo "<script>document.domain = '" . coreFunctions::removeSubDomain(_CONFIG_CORE_SITE_HOST_URL) . "';</script>";
    $upload_handler->remote_url_event_callback(array("done" => $fileUploadError));
    exit;
}

// include plugin code
$params = pluginHelper::includeAppends('url_upload_handler.php', array('url'   => $url, 'rowId' => $rowId));
$url    = $params['url'];

// 1KB of initial data, required by Webkit browsers
echo "<span>" . str_repeat("0", 1000) . "</span>";

// allow sub-domains for remote file servers
echo "<script>document.domain = '" . coreFunctions::removeSubDomain(_CONFIG_CORE_SITE_HOST_URL) . "';</script>";

$upload_handler->handleRemoteUrlUpload($url, $rowId);
