<?php

// core plugin config
$pluginConfig = array();
$pluginConfig['plugin_name'] = 'Torrent Download';
$pluginConfig['folder_name'] = 'torrentdownload';
$pluginConfig['plugin_description'] =
    'Allow your users to download torrents or magnet links directly into their account.';
$pluginConfig['plugin_version'] = 4;
$pluginConfig['required_script_version'] = '4.0';
$pluginConfig['database_sql'] = 'offline/database.sql';

// plugin admin area settings, links are relative to the plugin root
// links in multi-dimentional arrays create sub-menus, first item in array is the top level
$pluginConfig['admin_settings'] = array();
$pluginConfig['admin_settings']['top_nav'] = array();
$pluginConfig['admin_settings']['top_nav'][] = array(array(
        'link_url' => '#',
        'link_text' => 'Torrents',
        'link_key' => 'torrents'), array(
        'link_url' => 'admin/list_torrent.php',
        'link_text' => 'View Torrents',
        'link_key' => 'torrents'));

// plugin package specific options, use
$pluginConfig['package_options'] = array();
$pluginConfig['package_options'][] = array('field_label'=>'Max Torrents Per Day', 'field_name'=>'max_torrents_per_day', 'default_value'=>5, 'field_description'=>'Max torrent downloads permitted per day.', 'field_type'=>'integer');
$pluginConfig['package_options'][] = array('field_label'=>'Max Concurrent Torrents', 'field_name'=>'max_concurrent_torrents', 'default_value'=>1, 'field_description'=>'Max concurrent torrents.', 'field_type'=>'integer');
$pluginConfig['package_options'][] = array('field_label'=>'Use Max Upload Size', 'field_name'=>'use_max_upload_size', 'default_value'=>'yes', 'field_description'=>'Users can not add torrents larger than their account max upload size.', 'field_type'=>'select', 'available_values'=>'["yes", "no"]');
