<?php

// security
include_once('../_local_auth.inc.php');

// prepare page variables
$pricing_label = '';
$period        = '1M';
$user_level_id = 2;
$price     = '';
$price_gbp     = '';
$price_eur     = '';

// check if this is an edit?
$fileServerId = null;
$formType     = 'add the';
if (isset($_REQUEST['gEditPricingId']))
{
    $gEditPricingId = (int) $_REQUEST['gEditPricingId'];
    if ($gEditPricingId)
    {
        $sQL            = "SELECT * FROM user_level_pricing WHERE id=" . (int) $gEditPricingId;
        $packageDetails = $db->getRow($sQL);
        if ($packageDetails)
        {
            $pricing_label = $packageDetails['pricing_label'];
            $period        = $packageDetails['period'];
            $user_level_id = $packageDetails['user_level_id'];
            $price     = $packageDetails['price'];

            $formType = 'update the';
        }
    }
}

// prepare result
$result          = array();
$result['error'] = false;
$result['msg']   = '';

$result['html'] = '<p style="padding-bottom: 4px;">Use the form below to ' . $formType . ' pricing details.</p>';
$result['html'] .= '<span id="popupMessageContainer"></span>';
$result['html'] .= '<form id="addPricingForm">';

$result['html'] .= '<div class="form">';
$result['html'] .= '<div class="clearfix alt-highlight">
                        <label>' . UCWords(adminFunctions::t("package_pricing_label", "package pricing label")) . ':</label>
                        <div class="input">
                            <input name="pricing_label" id="pricing_label" type="text" value="' . adminFunctions::makeSafe($pricing_label) . '" class="large"/><br/>
                            <span style="margin-top: 4px; display: block; width: 500px;">
                                The description of the pricing shown to the user. i.e. 1 Year Plan
                            </span>
                        </div>
                    </div>';
$result['html'] .= '<div class="clearfix">
                        <label>' . UCWords(adminFunctions::t("payment_period", "payment period")) . ':</label>
                        <div class="input">
                            <select name="period" id="period" class="medium">';
$options = array('1D'  => '1 Day', '2D'  => '2 Days', '3D'  => '3 Days', '7D'  => '7 Days', '10D' => '10 Days', '14D' => '14 Days', '21D' => '21 Days', '28D' => '28 Days', '1M'  => '1 Month', '2M'  => '2 Months', '3M'  => '3 Months', '4M'  => '4 Months', '5M'  => '5 Months', '6M'  => '6 Months', '9M'  => '9 Months', '1Y'  => '1 Year', '2Y'  => '2 Years');
foreach ($options AS $k => $option)
{
    $result['html'] .= '        <option value="' . $k . '"';
    if ($period == $k)
    {
        $result['html'] .= '        SELECTED';
    }
    $result['html'] .= '        >' . UCWords($option) . '</option>';
}
$result['html'] .= '        </select><br/>
                            <span style="margin-top: 4px; display: block; width: 500px;">
                                The length of the upgraded membership.
                            </span>
                        </div>
                    </div>';
$result['html'] .= '<div class="clearfix alt-highlight">
                        <label>User Package:</label>
                        <div class="input">
                            <select name="user_level_id" id="user_level_id" class="medium">';
$options = $db->getRows('SELECT level_id, label FROM user_level WHERE level_type = \'paid\' ORDER BY level_id ASC');
foreach ($options AS $option)
{
    $result['html'] .= '        <option value="' . $option['level_id'] . '"';
    if ($user_level_id == $option['level_id'])
    {
        $result['html'] .= '        SELECTED';
    }
    $result['html'] .= '        >' . UCWords($option['label']) . '</option>';
}
$result['html'] .= '        </select><br/>
                            <span style="margin-top: 4px; display: block; width: 500px;">
                                Choose the package this pricing applies to. Only \'paid\' packages are shown above.
                            </span>
                        </div>
                    </div>';
$result['html'] .= '<div class="clearfix">
                        <label>' . UCWords(adminFunctions::t("package_price", "package price")) . ':</label>
                        <div class="input">
                            '.SITE_CONFIG_COST_CURRENCY_SYMBOL.' <input name="price" id="price" type="text" value="' . adminFunctions::makeSafe(number_format($price, 2)) . '" class="small"/>&nbsp;&nbsp;'.SITE_CONFIG_COST_CURRENCY_CODE.'
                        </div>
                    </div>';

$result['html'] .= '</form>';

echo json_encode($result);
exit;
