
function WriteReportFile()
{
   var job_data = "\n";
   
   job_data += "<html>\n";
   job_data += "<head>\n";
   job_data += "<style type='text/css'>\n";
   job_data += "BODY{background-color:#FFFFFF; font-family:arial,helvetica; font-size:12pt; text-align:justify; color:black;}\n";
   job_data += "H1{FONT-WEIGHT:bold; FONT-SIZE:16pt; COLOR: #FFFFFF; BACKGROUND-COLOR: #345789; FONT-FAMILY: Arial, Helvetica, sans-serif; TEXT-ALIGN:left;}\n";
   job_data += "H2{FONT-WEIGHT:bold; FONT-SIZE:14pt; COLOR:#345789; FONT-FAMILY:Arial, Helvetica, sans-serif; TEXT-ALIGN:left; margin-bottom:0; margin-top:6}\n";
   job_data += "H3{FONT-WEIGHT:bold; FONT-SIZE:12pt; COLOR:#345789; FONT-FAMILY:Arial, Helvetica, sans-serif; TEXT-ALIGN:left; margin-bottom:0; margin-top:6}\n";
   job_data += "</style>\n";
   job_data += "</head>\n<body>";
   job_data += "<H1><b>ArtCAM Jewellery Edition Job Report</b></H1>\n";
   job_data += "<table id=summary_table cellspacing=0 cellpadding=0 border=0>\n";
   job_data += "<tr><td colspan=3><H2>" + gRingInformation.job_name + " - " + gRingInformation.size_description + "</H2></td></tr>\n";
   job_data += "<tr> <td></td> <td>Diameter </td><td>: <b>" + gRingInformation.diameter + "mm</b> (Radius = <b>" + gRingInformation.diameter/2 +"mm</b>)</td></tr>\n";
   job_data += "<tr> <td></td> <td>Shank Thickness </td><td>: <b>" + gRingInformation.shank_thickness + "mm</b></td></tr>\n";
   job_data += "</table>\n\n";
   
   var DirSelector = artcam.CreateFileSelector();
   if (DirSelector == null)
   {
      artcam.Alert("Failed to create file selector",0);
      return;
   }

   var JobRootDirectory = GetJobRoot();
   if(JobRootDirectory=="")
      return false;

   var report_filepath = JobRootDirectory + gRingInformation.job_name +  "\\Report";

   // If the report directory doesn't exist, create it
   if(!DirSelector.DirectoryExists(report_filepath))
   {
      if (!DirSelector.CreateDirectory(report_filepath))
      {
         artcam.Alert("Failed to create directory\n" + report_filepath,0);
         return;
      }
   }
   var info_filepath = report_filepath +  "\\Report.htm";
   DirSelector.WriteTextFile(info_filepath, job_data);
}

function WriteFileInfoToReport()
{   
   var model = artcam.CurrentModel;
   if(model==null)
   {
      artcam.Alert("Failed to get current model",0);
      return;
   }

   var relief = artcam.Relief;
   if(relief==null)
   {
      artcam.Alert("Failed to get current relief",0);
      return;
   }

   var DirSelector = artcam.CreateFileSelector();
   if (DirSelector == null)
   {
      artcam.Alert("Failed to create file selector",0);
      return;
   }

   var JobRootDirectory = GetJobRoot();
   if(JobRootDirectory=="")
      return false;
   
   // If the report file doesn't exist, create it
   var info_filepath = JobRootDirectory + gRingInformation.job_name +  "\\Report\\Report.htm";
   if(!DirSelector.FileExists(info_filepath))
   {
      WriteReportFile();
   }

   var image_filepath = JobRootDirectory + gRingInformation.job_name +  "\\Report\\" + model.ModelName + ".jpg";

   model.Save3DViewImage(image_filepath);

   if(!DirSelector.FileExists(info_filepath))
   {
      artcam.Alert("Report File does not exist",0);
      return;
   }

   var job_data = DirSelector.ReadTextFile(info_filepath);
   var delimiter = "<!--**SECTION**-->";
   //var file_sections =  info_contents.split(delimiter);

   var units;
   if(model.InMM)
      units = "mm";
   else
      units = "inches";

   var file_data = "\n";
   file_data += "<table id=summary_table cellspacing=0 cellpadding=0 border=0>\n";
   file_data += "<tr><td colspan=7><H2>" + model.ModelName + "</H2></td></tr>\n";
   file_data += "<tr><td colspan=6>" + model.FileName + "</td><td rowspan=6><img src='" + image_filepath + "' style='height:150px' onclick=\"window.open('" + model.ModelName + ".jpg" + "',null,'status=no,toolbar=no,menubar=no,location=no');\"></td></tr>\n";
   file_data += "<tr><td colspan=6>" + model.NotesText + "</td></tr>\n";
   file_data += "<tr><td>Size </td><td>:</td><td><b>" + Round(model.RealWidth,3) + units + "</b> (<b>" + model.PixelWidth +" points</b>)</td><td>by</td><td></td><td><b>" + Round(model.RealHeight,3) + units + "</b> (<b>" + model.PixelHeight + " points</b>)</td></tr>\n";
   file_data += "<tr><td>MinX </td><td>:</td><td><b>" + Round(relief.MinX,3) + units + "</b></td><td>MaxX </td><td>:</td><td><b>" + Round(relief.MaxX,3) + units + "</b></td></tr>\n";
   file_data += "<tr><td>MinY </td><td>:</td><td><b>" + Round(relief.MinY,3) + units + "</b></td><td>MaxY </td><td>:</td><td><b>" + Round(relief.MaxY,3) + units + "</b></td></tr>\n";
   file_data += "<tr><td>MinZ </td><td>:</td><td><b>" + Round(relief.MinZ,3) + units + "</b></td><td>MaxZ </td><td>:</td><td><b>" + Round(relief.MaxZ,3) + units + "</b></td></tr>\n";
   
   gtoolpath_data = "\n";
   var count = artcam.ToolpathCount;
   var num_toolpaths = 0;
   for (var cur_toolpath_idx = 0; cur_toolpath_idx < count; cur_toolpath_idx++ )    
   {
      var toolpath = artcam.GetToolpath(cur_toolpath_idx);
      gtoolpath_data += "<tr><td colspan=7><H2>" + toolpath.Name + "</H2></td></tr>\n";
      ParseToolpaths(toolpath);
   }

   file_data += gtoolpath_data;

   file_data += "</table>\n\n";
   job_data+=file_data;

   DirSelector.WriteTextFile(info_filepath, job_data);
}

function ParseToolpaths(toolpath)
{
   var num_children = toolpath.GetNumberOfChildren();
   if(num_children>0)
   {
      for (var n = 0; n < num_children; n++)
      {
         var child_toolpath = toolpath.GetChild(n);
         ParseToolpaths(child_toolpath);
      }
   }
   else
      WriteToolpathInformation(toolpath);
}


function WriteToolpathInformation(toolpath)
{
      var tool = toolpath.GetTool();
      gtoolpath_data += "\n";
      gtoolpath_data += "<tr><td colspan=7><H3>" + toolpath.ToolDescription + "</H3></td></tr>\n";
      gtoolpath_data += "<tr><td>Machining Time</td><td>:</td><td><b>" + toolpath.EstimatedMachiningTime + "</b></td><td colspan=3></td></tr>\n";
      gtoolpath_data += "<tr><td>Machining Area</td><td>:</td><td colspan=5>Width:<b>" + Round(toolpath.BoundingBoxXLength,3) + "</b>&nbsp;Height:<b>" + Round(toolpath.BoundingBoxYLength,3) + "</b>&nbsp;Depth:<b>" + Round(toolpath.BoundingBoxZLength,3) + "</b></td></tr>\n";
     
      gtoolpath_data += "<tr><td>Feed Rate </td><td>:</td><td><b>" + toolpath.Feedrate + "</b></td><td colspan=3></td></tr>\n";
      gtoolpath_data += "<tr><td>Plunge Rate </td><td>:</td><td><b>" + toolpath.Plungerate + "</b></td><td colspan=3></td></tr>\n";
      gtoolpath_data += "<tr><td>Spindle Speed </td><td>:</td><td><b>" + toolpath.SpindleSpeed + "</b></td><td colspan=3></td></tr>\n";
      gtoolpath_data += "<tr><td>StepOver </td><td>:</td><td><b>" + tool.Stepover + "</b></td><td colspan=3></td></tr>\n";
      gtoolpath_data += "<tr><td>Tolerance </td><td>:</td><td><b>" + toolpath.ToolpathTolerance + "</b></td><td colspan=3></td></tr>\n";
      gtoolpath_data += "<tr><td>Allowance </td><td>:</td><td><b>" + toolpath.Allowance + "</b></td><td colspan=3></td></tr>\n";
      
      gtoolpath_data += "<tr><td>Home </td><td>:</td><td colspan=5>X:<b>" + toolpath.HomePositionX + "</b>&nbsp;Y:<b>" + toolpath.HomePositionY + "</b>&nbsp;Z:<b>" + toolpath.HomePositionZ + "</b></td></tr>\n";
      gtoolpath_data += "<tr><td>SafeZ </td><td>:</td><td><b>" + toolpath.SafeZ + "</b></td><td colspan=3></td></tr>\n";
}

