// Calling page must have paramsDiv & libraryDiv objects for these functions
// show and manipulate
function plugin_main()
{
   // Hide the library div
   HideAllLibraryDivs();
   paramsDiv.style.display = "";
   paramsDiv.innerHTML = "";

   globalStore.OnBack = OnBack;
   globalStore.OnFinish = OnFinish;
   globalStore.OnBuild = OnBuild;
   globalStore.OnCreatePlain = OnCreatePlain;

   globalStore.ActiveShank = new Shank();
   globalStore.ActiveShank.DefaultName=gDefaultName;
   globalStore.ActiveShank.UseForwardButton = true;
   globalStore.ActiveShank.CallbackFunction = OnGotShankParams;
   globalStore.ActiveShank.ThicknessParamVisible = false;
   globalStore.ActiveShank.WidthParamVisible = false;
   globalStore.ActiveShank.WriteParamsHTML(paramsDiv);
}

function Write_params(targetDiv)
{
   var hArr = new Array();
   // Add the back button HTML to the array

   hArr.push("<table width='100%' border=0 cellspacing=0 style='margin-left:3px'>");
   hArr.push("<colgroup><col width=40px><col width=60%><col width=40%></colgroup>");
   hArr.push("<tr HELPTAG style='display:none'><td colspan=3><img align=left src='" + artcam.HtmlRootDir + "../SharedImages/help.gif'>&nbsp;" + gFormHelp + "</td></tr>");
   hArr.push("<tr><td rowspan=2><img src='" + artcam.HtmlRootDir + "../SharedImages/JewelSmith/ShankThicknesses.gif'</td>");
      hArr.push("<td>" + gTopThickness + ":</td><td><input type=edit id=TopThicknessEdit number positive size=5>mm</td></tr>");
   hArr.push("<tr><td>" + gBottomThickness + ":</td><td><input type=edit id=BottomThicknessEdit number positive size=5>mm</td></tr>");
   hArr.push("<tr><td rowspan=2><img src='" + artcam.HtmlRootDir + "../SharedImages/JewelSmith/ShankWidths.gif'</td>");
      hArr.push("<td>" + gTopWidth + ":</td><td><input type=edit id=TopWidthEdit number positive size=5>mm</td></tr>");
   hArr.push("<tr><td>" + gBottomWidth + ":</td><td><input type=edit id=BottomWidthEdit number positive size=5>mm</td></tr>");
   hArr.push("</table>");

   hArr.push("<div class='mouseOut' button_name='forward_button' id=ForwardButton targetFunction='globalStore.OnCreatePlain' style='width=30px;float:right'>");
   hArr.push("<img alt =" + gForwardButtonAlt + " id=forward_img src ='" + artcam.HtmlRootDir + "../SharedImages/forward.gif' align=absmiddle border=0 width=30 height=30>");
   hArr.push("</div>");

   hArr.push("<div class='mouseOut' button_name='rebuild_button' id=RebuildButton targetFunction='globalStore.OnBuild' style='width=30px;float:right;display:none'>");
   hArr.push("<img alt =" + gRebuildButtonAlt + " id=rebuild_img src ='" + artcam.HtmlRootDir + "../SharedImages/rebuild.gif' align=absmiddle border=0 width=30 height=30>");
   hArr.push("</div>");

   hArr.push("<div class='mouseOut' button_name='back_button' id=BackButton targetFunction='globalStore.OnBack' style='width=30px;float:right'>");
   hArr.push("<img alt =" + gBackButtonAlt + " id=back_img src ='" + artcam.HtmlRootDir + "../SharedImages/back.gif' align=absmiddle border=0 width=30 height=30>");
   hArr.push("</div>");

   targetDiv.innerHTML += hArr.join("\n");
   // Bung all our HTML into the div and display it
   InitialiseButtonDivs();
   SubclassNumberEditControls();

   RetrievePreviousSettings();
}

function OnCreatePlain()
{
   RememberCurrentSettings();

   globalStore.ActiveShank.Thickness = ( TopThicknessEdit.getValue() + BottomThicknessEdit.getValue() )/2;
   globalStore.ActiveShank.Width = TopWidthEdit.getValue() > BottomWidthEdit.getValue() ? TopWidthEdit.getValue() : BottomWidthEdit.getValue();

   artcam.ProjectAssembly.SetFlag("BuildingFlag", CreateRotaryShankFromShankObject(globalStore.ActiveShank));
   if(false == artcam.ProjectAssembly.GetFlag("BuildingFlag", false))
   {
      return false;
   }

   artcam.CurrentModel.Rename(globalStore.ActiveShank.Name, false);

   var vector = artcam.Vectors.CreateVector();
   if (typeof(vector)!="object")
   {
      artcam.Alert("Failed to create vector",0);
      return false;
   }

   var x_origin = -artcam.CurrentModel.RealWidth/2.0;
   var x_step = artcam.CurrentModel.RealWidth/6.0;

   vector.MoveTo(x_origin,BottomWidthEdit.getValue()/2);
   var control_1_x = x_origin + x_step;
   var control_1_y = BottomWidthEdit.getValue()/2;
   var control_2_x = x_origin + (x_step*2);
   var control_2_y = TopWidthEdit.getValue()/2;
   var end_x = 0;
   var end_y = TopWidthEdit.getValue()/2;
   vector.BezierTo(control_1_x, control_1_y, control_2_x, control_2_y, end_x, end_y);

   control_1_x = x_origin + (x_step*4);
   control_1_y = TopWidthEdit.getValue()/2;
   control_2_x = x_origin + (x_step*5);
   control_2_y = BottomWidthEdit.getValue()/2;
   end_x = artcam.CurrentModel.RealWidth/2.0;
   end_y = BottomWidthEdit.getValue()/2;
   vector.BezierTo(control_1_x, control_1_y, control_2_x, control_2_y, end_x, end_y);

   artcam.Vectors.AddVectorToArtcam(vector);
   globalStore.Rail1ID = vector.VectorID;

   vector = artcam.Vectors.CreateVector();
   if (typeof(vector)!="object")
   {
      artcam.Alert("Failed to create vector",0);
      return false;
   }

   vector.MoveTo(x_origin,-BottomWidthEdit.getValue()/2);
   control_1_x = x_origin + x_step;
   control_1_y = -BottomWidthEdit.getValue()/2;
   control_2_x = x_origin + (x_step*2);
   control_2_y = -TopWidthEdit.getValue()/2;
   end_x = 0;
   end_y = -TopWidthEdit.getValue()/2;
   vector.BezierTo(control_1_x, control_1_y, control_2_x, control_2_y, end_x, end_y);

   control_1_x = x_origin + (x_step*4);
   control_1_y = -TopWidthEdit.getValue()/2;
   control_2_x = x_origin + (x_step*5);
   control_2_y = -BottomWidthEdit.getValue()/2;
   end_x = artcam.CurrentModel.RealWidth/2.0;
   end_y = -BottomWidthEdit.getValue()/2;
   vector.BezierTo(control_1_x, control_1_y, control_2_x, control_2_y, end_x, end_y);
   artcam.Vectors.AddVectorToArtcam(vector);
   globalStore.Rail2ID = vector.VectorID;

   globalStore.Middle_Profile_ID = DrawAngledProfile(TopWidthEdit.getValue(), TopThicknessEdit.getValue(),82);
   globalStore.End_Profile_ID = DrawAngledProfile(BottomWidthEdit.getValue(), BottomThicknessEdit.getValue(),82);
   artcam.SelectedVectorID = globalStore.End_Profile_ID;
   artcam.MoveVectors(-artcam.CurrentModel.RealWidth/2,0);

   globalStore.ZCurveID = DrawZModulationCurve(TopThicknessEdit.getValue(),BottomThicknessEdit.getValue());

   return OnBuild();
}

function OnFinish()
{
   SaveArtFile("Shank", globalStore.ActiveShank.Name);
   StoreCurrentSettings();
   OnCloseAndGotoAssistantTab();
}

function OnBuild()
{
   if(SettingsChanged())
      if (false == OnCreatePlain())
         return false;

   artcam.Relief.SetAllHeights(artcam.Relief.BaseHeight);
   var temp_relief = artcam.CreateEmptyRelief();
   temp_relief.CopyFromCurrent();
   temp_relief.BaseHeight = 0;
   temp_relief.Reset();

   var sweep_info = artcam.CreateTwoRailSweepData();
   sweep_info.SetRail1(globalStore.Rail1ID);
   sweep_info.SetRail2(globalStore.Rail2ID);
   sweep_info.SetZModCurve(globalStore.ZCurveID);
   sweep_info.AddCrossSection(globalStore.End_Profile_ID,0,0,0.3,0.3,false);
   sweep_info.AddCrossSection(globalStore.Middle_Profile_ID,0.5,0.5,0.3,0.3,false);
   sweep_info.AddCrossSection(globalStore.End_Profile_ID,1,1,0.3,0.3,false);
   var min_x= artcam.Relief.MinX;
   var max_x= artcam.Relief.MaxX;
   var min_y= artcam.Relief.MinY;
   var max_y= artcam.Relief.MaxY;
   var cen_y = (min_y + max_y) / 2.0;
   sweep_info.UseLinearZModulation(min_x, cen_y, max_x, cen_y);
   sweep_info.ZModCurveIsAbsolute = true;
   sweep_info.ZModCurveIsWrapped = true;

   artcam.TwoRailSweep(sweep_info, temp_relief);
   temp_relief.MergeHighestWithCurrent();

   var RingDesigner = artcam.CreateRingDesigner();
   RingDesigner.PatchSweepRoundingError();

   forward_img.src = artcam.HtmlRootDir + "../SharedImages/accept.gif";
   forward_img.alt = gAcceptButtonAlt;
   ForwardButton.targetFunction = 'globalStore.OnFinish';
   RebuildButton.style.display = "";

   return true;
}

function OnGotShankParams(completed)
{
   if(completed)
   {
      paramsDiv.innerHTML = "";
      Write_params(paramsDiv);
   }
   else
   {
      OnBackButton();
   }
}

function StoreCurrentSettings()
{
   artcam.StoreDouble("TaperedShank", "TopThickness", TopThicknessEdit.getValue());
   artcam.StoreDouble("TaperedShank", "BottomThickness", BottomThicknessEdit.getValue());
   artcam.StoreDouble("TaperedShank", "TopWidth", TopWidthEdit.getValue());
   artcam.StoreDouble("TaperedShank", "BottomWidth", BottomWidthEdit.getValue());
}

function RetrievePreviousSettings()
{
   TopThicknessEdit.setValue(artcam.RetrieveDouble("TaperedShank", "TopThickness", 3));
   BottomThicknessEdit.setValue(artcam.RetrieveDouble("TaperedShank", "BottomThickness", 1.5));
   TopWidthEdit.setValue(artcam.RetrieveDouble("TaperedShank", "TopWidth", 4));
   BottomWidthEdit.setValue(artcam.RetrieveDouble("TaperedShank", "BottomWidth", 2));
}

function RememberCurrentSettings()
{
   globalStore.TopThicknessEditValue = TopThicknessEdit.getValue();
   globalStore.BottomThicknessEditValue = BottomThicknessEdit.getValue();
   globalStore.TopWidthEditValue = TopWidthEdit.getValue();
   globalStore.BottomWidthEditValue = BottomWidthEdit.getValue();
}

function SettingsChanged()
{
   if(globalStore.TopThicknessEditValue != TopThicknessEdit.getValue())
      return true;
   if(globalStore.BottomThicknessEditValue != BottomThicknessEdit.getValue())
      return true;
   if(globalStore.TopWidthEditValue != TopWidthEdit.getValue())
      return true;
   if(globalStore.BottomWidthEditValue != BottomWidthEdit.getValue())
      return true;

   return false;
}

function OnBack()
{
   var currTab = artcam.CurrentTab;
   OldOnModelClosed = OnModelClosed;
   OnModelClosed = function() {};
   artcam.ForceModelClose();
   OnModelClosed = OldOnModelClosed;
   artcam.CurrentTab = currTab;
   paramsDiv.innerHTML = "";
   globalStore.ActiveShank.WriteParamsHTML(paramsDiv);
}

function OnModelClosed()
{
   if (true == artcam.ProjectAssembly.GetFlag("BuildingFlag", false))
   {
      OnClose();
   }
}
