function DrawCuspProfile(profile_width, profile_height)
{
   var profile_vector = artcam.Vectors.CreateVector();
   if (typeof(profile_vector)!="object")
   {
      artcam.Alert("Failed to create vector",0);
      return;
   } 

   profile_vector.MoveTo(0,0);
   var control_1_x = 0;
   var control_1_y = profile_height/2;
   var control_2_x = profile_width/5;
   var control_2_y = profile_height;
   var end_x = profile_width/2;
   var end_y = profile_height;

   profile_vector.BezierTo(control_1_x, control_1_y, control_2_x, control_2_y, end_x, end_y);

   control_1_x = (profile_width/5)*4;
   control_1_y = profile_height;
   control_2_x = profile_width;
   control_2_y = profile_height/2;
   end_x = profile_width;
   end_y = 0;

   profile_vector.BezierTo(control_1_x, control_1_y, control_2_x, control_2_y, end_x, end_y);

   artcam.Vectors.AddVectorToArtcam(profile_vector);
   return profile_vector.VectorID;
}

function DrawVCutProfile(profile_width, profile_height)
{

   var profile_vector = artcam.Vectors.CreateVector();
   if (typeof(profile_vector)!="object")
   {
      artcam.Alert("Failed to create vector",0);
      return;
   } 

   var half_width = profile_width/2;

   profile_vector.MoveTo(0,0);
   profile_vector.LineTo(half_width, profile_height);
   profile_vector.LineTo(profile_width, 0);

   artcam.Vectors.AddVectorToArtcam(profile_vector);
   return profile_vector.VectorID;
}

function DrawAngledProfile(profile_width, profile_height, angle)
{
   var x_offset=0;
   
   if(angle<90)
   {
      var rad_angle = (90-angle) * (Math.PI / 180.0);
      x_offset = Math.tan(rad_angle) * profile_height;
      
      if(x_offset>profile_width/2)
      {
         //alert(profile_height + " Oops offset = " + x_offset);
         x_offset = profile_width/2;
      }
   }
   
   var profile_vector = artcam.Vectors.CreateVector();
   if (typeof(profile_vector)!="object")
   {
      artcam.Alert("Failed to create vector",0);
      return;
   } 

   var half_width = profile_width/2;

   profile_vector.MoveTo(0,0);
   profile_vector.LineTo(0 + x_offset, profile_height);
   profile_vector.LineTo(profile_width - x_offset, profile_height);
   profile_vector.LineTo(profile_width, 0);

   artcam.Vectors.AddVectorToArtcam(profile_vector);
   return profile_vector.VectorID;
}

function DrawZModulationCurve(top,bottom)
{
   var current_selection = artcam.VectorSelection.Selection;
   var silhouette_centre_x = GetRingSilhouetteCentre("x", true);
   var silhouette_centre_y = GetRingSilhouetteCentre("y", true);
   var radius = (globalStore.ActiveShank.Diameter + top + bottom) / 2;
   var y_offset = radius - bottom - (globalStore.ActiveShank.Diameter/2);
   artcam.DrawCircle(silhouette_centre_x, silhouette_centre_y + y_offset, radius, false);
   var vector = artcam.VectorSelection.Item(0); 
   artcam.VectorSelection.Selection = current_selection;
   return vector.VectorID;
}