// Calling page must have paramsDiv & libraryDiv objects for these functions
// show and manipulate

function plugin_main()
{
   HideAllLibraryDivs();
   paramsDiv.style.display = "";
   Write_params(paramsDiv);

   globalStore.OnSetGems = OnSetGems;
   globalStore.AddGemsToProjectAssembly = AddGemsToProjectAssembly;
}

function Write_params(targetDiv)
{
   targetDiv.innerHTML = "";
   var hArr = new Array();
   // Add the back button HTML to the array

   // Find out what type of page we are on - some controls are not needed
   var model_creation_page_name = artcam.CurrentModel.GetString("Ring_creation_page_name", "Failed");

   hArr.push("<table width='100%' border=0 cellspacing=0 style='margin-left:3px;table-layout:fixed'>");
   hArr.push("<col width=30px><col width=30%><col width=70%>");
   hArr.push("<tr><td></td><td colspan=2><input type=checkbox id='UseOnlySelectedVectors' checked>"+gCreateFromSelectedVectors+"<hr></td></tr>");
   hArr.push("<tr><td></td><td>"+gGemSetName+"</td><td><input type=edit id='AssemblyNameEdit'</td></tr>");
   hArr.push("<tr><td></td><td>"+gStartHeight+"</td><td><input type=edit number size=5 id='StartHeightEdit'</td></tr>");
   if(artcam.RingReliefExists())
   {
      hArr.push("<tr><td></td><td colspan=2><input type=checkbox checked id='PositionOnRingCheck'>"+gPositionAroundRing+"</td></tr>");
   }
   hArr.push("<tr><td></td><td colspan=2><input type=checkbox id='NormalFromReliefCheck'>"+gLayOnRelief+"</td></tr>");
   hArr.push("</table>");

   hArr.push("<div class='mouseOut' button_name='accept_button' id=AcceptButton targetFunction='globalStore.AddGemsToProjectAssembly' style='width=30px;float:right;display:none'>");
   hArr.push("<img id=back_img src ='" + artcam.HtmlRootDir + "../SharedImages/accept.gif' align=absmiddle border=0 width=30 height=30>");
   hArr.push("</div>");

   hArr.push("<div class='mouseOut' button_name='forward_button' id=ForwardButton targetFunction='globalStore.OnSetGems' style='width=30px;float:right;'>");
   hArr.push("<img id=ForwardButtonImage src ='" + artcam.HtmlRootDir + "../SharedImages/forward.gif' align=absmiddle border=0 width=30 height=30>");
   hArr.push("</div>");

   AddBackButtonHTML(hArr);

   targetDiv.innerHTML += hArr.join("\n");
   InitialiseButtonDivs();
   SubclassNumberEditControls();

   var splitpath = artcam.CreateSplitPath(artcam.CurrentModel.ModelName);
   splitpath.Extension ="";
   StartHeightEdit.setValue(0);
   if(artcam.RingReliefExists())
   {
      globalStore.PositionOnRingCheck   = eval(PositionOnRingCheck);
   }
   globalStore.NormalFromReliefCheck = eval(NormalFromReliefCheck);
   globalStore.AcceptButton = eval(AcceptButton);
   globalStore.ForwardButtonImage = eval(ForwardButtonImage);
   globalStore.AssemblyNameEdit = eval(AssemblyNameEdit);
   globalStore.AssemblyNameEdit.value = splitpath.File + gGems;

   // Bung all our HTML into the div and display it
}

function OnSetGems()
{
   if(artcam.CommandsOK())
   {
      // Find out what type of page we are on
      var model_creation_page_name = artcam.CurrentModel.GetString("Ring_creation_page_name", "Failed");

      // Reload our Gem array
      globalStore.GemArray = new Array();

      // We either loop through the selection or all the vectors
      var vector_array = CreateGemVectorArray(UseOnlySelectedVectors.checked);
      if( vector_array.length == 0 )
      {
         artcam.MessageBox(gNoGemVectorsSelected);
         return;
      }

      var start_height = StartHeightEdit.getValue();
      var bSomeGemsOutsideModelBoundary = false;

      for (var index in vector_array)
      {
         var gem = new Gem();
         gem.RetrieveInfoFromVectorObject(vector_array[index]);
         gem.SetPositionFromRelief(globalStore.NormalFromReliefCheck.checked);
         //  rlfInvalidHeight = 9876543
         if(gem.ZPosition>9000000)
         {
            bSomeGemsOutsideModelBoundary = true;
            continue;
         }

         gem.CreateModel();

         if(artcam.RingReliefExists() && globalStore.PositionOnRingCheck.checked)
         {
            gem.PositionAroundRing();
         }

         // Offset the start_height according to whether we are laying on the relief or not
         var offset = globalStore.NormalFromReliefCheck.checked ? 0 : -gem.ZPosition;
         gem.GemModel.Transform(0,0,start_height + offset,1,1,1,0,0,0,0,0,0,true,false);

         // Stash the new gem in globalStore.
         globalStore.GemArray[index] = gem;
      }

      if (bSomeGemsOutsideModelBoundary)
      {
         artcam.MessageBox(gSomeGemsOutsideModelBoundary);
      }

      ForwardButtonImage.src = artcam.HtmlRootDir + "../SharedImages/rebuild.gif";
      AcceptButton.style.display = "";
   }
   else
      artcam.MessageBox(gArtcamIsBusy);
}

function AddGemsToProjectAssembly()
{
   // Find out what type of page we are on
   var model_creation_page_name = artcam.CurrentModel.GetString("Ring_creation_page_name", "Failed");

   if(typeof(globalStore.GemArray)!='object')
   {
      OnBackButton();
      return;
   }

   if(!globalStore.GemArray.length>0)
   {
      OnBackButton();
      return;
   }

   if(globalStore.AssemblyNameEdit.value=="")
   {
      artcam.MessageBox(gNoName);
      return;
   }

   var assembly = artcam.CreateAssembly(globalStore.AssemblyNameEdit.value);

   for (var index in globalStore.GemArray)
   {
      assembly.AppendGemSet(globalStore.GemArray[index].GemModel);
      globalStore.GemArray[index].GemModel.InDisplayList=false;

      // Account for different model types - ONLY NEED TO DO THIS WHEN SETTING IN THE ASSEMBLY
      if(model_creation_page_name == "ThreeAxis")
         globalStore.GemArray[index].GemModel.Transform(0,0,0,1,1,1,-90,0,90,0,0,0,false,false);
      else if (model_creation_page_name == "ThreeAxisV")
         globalStore.GemArray[index].GemModel.Transform(0,0,0,1,1,1,0,0,90,0,0,0,false,false);
   }

   artcam.ProjectAssembly.AppendChild(assembly);
   artcam.ProjectAssembly.UpdateAssemblyMonitor();
   artcam.ProjectAssembly.InDisplayList=true;
   assembly.InDisplayList=false;
   assembly = 0;
   globalStore.GemArray = 0;
   OnBackButton();
}
