// Calling page must have paramsDiv & libraryDiv objects for these functions
// show and manipulate

function plugin_main()
{
   // Hide the library div
   HideAllLibraryDivs();
   write_params(paramsDiv);

   globalStore.OnChangePaveType          = OnChangePaveType;
   globalStore.OnChangeBeadDiaOrGapRadio = OnChangeBeadDiaOrGapRadio;
   globalStore.OnChangePaveAreaRadio     = OnChangePaveAreaRadio;
   globalStore.OnCreate                  = OnCreate;
   globalStore.OnSelectStones            = OnSelectStones;
   globalStore.OnSelectBeads             = OnSelectBeads;
   globalStore.OnSelectAll               = OnSelectAll;
   globalStore.OnTrim                    = OnTrim;
   globalStore.OnDelete                  = OnDelete;
   globalStore.OnAccept                  = OnAccept;
   globalStore.OnBack                    = OnBack;

   globalStore.PaveAssistant             = artcam.Drawing.CreatePaveAssistant();

   // Hook into the selection change mechanism and call it to set the page in the right state
   //globalStore.OnVectorSelectionChanged = OnVectorSelectionChanged;
   //globalStore.OnVectorSelectionChanged();
}

function write_params(targetDiv)
{
   targetDiv.innerHTML = "";

   var html = new Array();
   html.push("");

   // Type
   html.push("<table width=100% border=0>");
   html.push("<tr>");
   html.push("   <td colspan=2><b>"+gPaveType+"</b></td>");
   html.push("</tr>");
   html.push("<tr>");
   html.push("   <td width=5%><img src='JewelSmith/PaveWizard/linear.gif' align=left vspace=5></td>");
   html.push("   <td><input type='radio' name='PaveTypeRadio' onclick='globalStore.OnChangePaveType()'>&nbsp;"+gLinear+"</td>");
   html.push("</tr>");
   html.push("<tr>");
   html.push("   <td><img src='JewelSmith/PaveWizard/honeycomb.gif' align=left vspace=5></td>");
   html.push("   <td><input type='radio' name='PaveTypeRadio' onclick='globalStore.OnChangePaveType()'>&nbsp;"+gHoneycomb+"</td>");
   html.push("</tr>");
   html.push("<tr>");
   html.push("   <td colspan=2><hr></td>");
   html.push("</tr>");
   html.push("</table>");

   // Stone and Prong / Bead size
   html.push("<table  width=100% border=0>");
   html.push("<tr>");
   html.push("   <td colspan=3><b>"+gSpacing+"</b></td>");
   html.push("</tr>");
   html.push("<tr>");
   html.push("   <td rowspan=3>&nbsp;&nbsp;</td>");
   html.push("   <td colspan=2>"+gStoneDia+"</td>");
   html.push("   <td>");
   html.push("   <input id='StoneDia' size=5 maxLength=6 number dp='4'>&nbsp<span units=true></span>");
   html.push("   </td>");
   html.push("</tr>");
   html.push("<tr>");
   html.push("   <td><input type='radio' id='BeadDiaOrGapRadio' onclick='globalStore.OnChangeBeadDiaOrGapRadio(true)'></td>");
   html.push("   <td>"+gBeadDia+"</td>");
   html.push("   <td>");
   html.push("   <input id='BeadDia' size=5 maxLength=6 number dp='4'>&nbsp<span id='BeadDiaUnits' units=true></span>");
   html.push("   </td>");
   html.push("</tr>");
   html.push("<tr>");
   html.push("   <td><input type='radio' id='BeadDiaOrGapRadio' onclick='globalStore.OnChangeBeadDiaOrGapRadio(false)'></td>");
   html.push("   <td>"+gStoneGap+"</td>");
   html.push("   <td>");
   html.push("   <input id='StoneGap' size=5 maxLength=6 number dp='4'>&nbsp<span id='StoneGapUnits' units=true></span>");
   html.push("   </td>");
   html.push("</tr>");
   html.push("");
   html.push("<tr>");
   html.push("   <td colspan=3><b>"+gArea+"</b></td>");
   html.push("</tr>");
   html.push("<tr>");
   html.push("   <td rowspan=3>&nbsp;&nbsp;</td>");
   html.push("   <td><input type='radio' id='PaveAreaRadio' onclick='globalStore.OnChangePaveAreaRadio(true)'></td>");
   html.push("   <td colspan=2><span id='SelectedVectorText'>"+gSelectedVector+"</span></td>");
   html.push("</tr>");
   html.push("");
   html.push("<tr>");
   html.push("   <td><input type='radio' id='PaveAreaRadio' onclick='globalStore.OnChangePaveAreaRadio(false)' checked></td>");
   html.push("   <td>"+gNumRows+"</td>");
   html.push("   <td>");
   html.push("   <input id='NumRows' size=3 maxLength=3 number dp='0'>");
   html.push("   </td>");
   html.push("</tr>");
   html.push("<tr>");
   html.push("   <td></td>");
   html.push("   <td>"+gNumColumns+"</td>");
   html.push("   <td>");
   html.push("   <input id='NumColumns' size=3 maxLength=3 number dp='0'>");
   html.push("   </td>");
   html.push("</tr>");
   html.push("");
   html.push("</table>");
   html.push("<div align='right' style='margin-right:10px'>");
   html.push("<br>");
   html.push("<INPUT  type='button' value='"+gCreateButton+"' onclick ='globalStore.OnCreate()'  id='CreateButton' >");
   html.push("<INPUT  type='button' value='"+gTrimButton+"' onclick ='globalStore.OnTrim()'  id='TrimButton' >");
   html.push("<INPUT  type='button' value='"+gDeleteButton+"' onclick ='globalStore.OnDelete()'  id='DeleteButton' >");
   html.push("<hr>");
   html.push("</div>");
   html.push("<div align='left' style='margin-right:10px'>");
   html.push("<b>" + gSelectVectors + "</b>");
   html.push("</div>");
   html.push("<div align='right' style='margin-right:10px'>");
   html.push("<INPUT  type='button' value='"+gSelectStonesButton+"' onclick ='globalStore.OnSelectStones()'  id='SelectStonesButton' >");
   html.push("<INPUT  type='button' value='"+gSelectBeadsButton+"' onclick ='globalStore.OnSelectBeads()'  id='SelectBeadsButton' >");
   html.push("<INPUT  type='button' value='"+gSelectAll+"' onclick ='globalStore.OnSelectAll()'  id='SelectAllButton' >");
   html.push("<HR>");
   html.push("</div>");

   //Add the gem colour drop down
   html.push("<table  width=100% border=0>");
   html.push("<tr>");
   html.push("<td colspan=3><b>"+gGemColour+"</b><td>");
   html.push("<tr>");
   html.push("<td>&nbsp;<td>");
   html.push("<td>");
   html.push("<select id='ColourCombo' name='ColourCombo'>");
   var gemshape_library_path = artcam.HtmlRootDir + "../GemLibrary/GemColours";
   var splitpath = artcam.CreateSplitPath(gemshape_library_path);
   // Now loop through all the gif files in this directory
   var dirList = artcam.CreateDirectoryList(gemshape_library_path);
   dirList.StartList("*.gif"); // Enumerate ALL items. '*' wild card matches everything
   while ( dirList.ItemIsValid() )
   {
      splitpath.Path = dirList.ItemPath;
      var gemName = GetPluginTitle(splitpath.Path, false);
      if (gemName != "Custom")
         html.push("<option>" + gemName + "</option>");
      dirList.NextItem();
   }
   html.push("</select>");
   html.push("</td>");
   html.push("</tr>");
   html.push("</table>");

   // Add the back and accept buttons HTML to the array
   html.push("<div class='mouseOut' button_name='accept_button' targetFunction='globalStore.OnAccept' style='width=30px;float:right;'>");
   html.push("<img alt =" + gAcceptButtonAlt + " id=back_img src ='" + artcam.HtmlRootDir + "../SharedImages/accept.gif' align=absmiddle border=0 width=30 height=30>");
   html.push("</div>");
   html.push("<div class='mouseOut' button_name='back_button' targetFunction='globalStore.OnBack' style='width=30px;float:right;'>");
   html.push("<img alt =" + gBackButtonAlt + " id=back_img src ='" + artcam.HtmlRootDir + "../SharedImages/back.gif' align=absmiddle border=0 width=30 height=30>");
   html.push("</div>");

   // Set the html in the div
   targetDiv.innerHTML = html.join("\n");
   targetDiv.style.display = "";

   InitialiseButtonDivs();
   SubclassNumberEditControls();
   SetUnitsSpans();

   MakeButtonsSameSize(CreateButton,TrimButton,DeleteButton,SelectStonesButton,SelectBeadsButton,SelectAllButton);

   // load initial page values - last calculated
   StoneDia.value    = artcam.RetrieveString("PaveWizard","StoneDia", "4.0");
   BeadDia.value     = artcam.RetrieveString("PaveWizard","BeadDia",  "0.8");
   StoneGap.value    = artcam.RetrieveString("PaveWizard","StoneGap", "0.1");
   NumRows.value     = artcam.RetrieveString("PaveWizard","NumRows", "5");
   NumColumns.value  = artcam.RetrieveString("PaveWizard","NumColumns", "5");

   if (artcam.RetrieveString("PaveWizard","PaveType", "0") == "0")
      PaveTypeRadio[0].checked = true;
   else
      PaveTypeRadio[1].checked = true;

   if (artcam.RetrieveString("PaveWizard","BeadOrGap","0") == "0")
      OnChangeBeadDiaOrGapRadio(true);
   else
      OnChangeBeadDiaOrGapRadio(false);

   if (artcam.VectorSelection.IsEmpty())
      OnChangePaveAreaRadio(false);
   else
      OnChangePaveAreaRadio(true);
}




// === OnChangePaveAreaRadio ==============================
//
// Called when user changes method used to specify area to cover
//

function OnChangePaveAreaRadio(select_vector)
{
   if (select_vector)
   {
      PaveAreaRadio[0].checked = true;
      PaveAreaRadio[1].checked = false;

      NumRows.disabled = true;
      NumRows.readOnly = true;
      NumRows.style.backgroundColor = 'buttonface';

      NumColumns.disabled = true;
      NumColumns.readOnly = true;
      NumColumns.style.backgroundColor = 'buttonface';

      TrimButton.disabled = false;
   }
   else
   {
      PaveAreaRadio[0].checked = false;
      PaveAreaRadio[1].checked = true;

      NumRows.disabled = false;
      NumRows.readOnly = false;
      NumRows.style.backgroundColor = 'window';

      NumColumns.disabled = false;
      NumColumns.readOnly = false;
      NumColumns.style.backgroundColor = 'window';

      TrimButton.disabled = true;
   }
}

// === OnChangePaveType ===================================
//
// Called when user changes type of pave being created
//
function OnChangePaveType()
{
}

// === OnChangeBeadDiaOrGapRadio ===========================
//
// called when user is changing the gap / bead diameter radio
//
function OnChangeBeadDiaOrGapRadio(do_bead)
{
// get checked option and disable other
   if (do_bead)
   {
      BeadDiaOrGapRadio[0].checked = true;
      BeadDiaOrGapRadio[1].checked = false;

      StoneGap.disabled = true;
      StoneGap.readOnly = true;
      StoneGap.style.backgroundColor = 'buttonface';
      StoneGapUnits.disabled = true;
      StoneGapUnits.disabled = true;

      BeadDia.disabled = false;
      BeadDia.readOnly = false;
      BeadDia.style.backgroundColor = 'window';
      BeadDiaUnits.disabled = false;
   }
   else
   {
      BeadDiaOrGapRadio[0].checked = false;
      BeadDiaOrGapRadio[1].checked = true;

      BeadDia.disabled = true;
      BeadDia.readOnly = true;
      BeadDia.style.backgroundColor = 'buttonface';
      BeadDiaUnits.disabled = true;

      StoneGap.disabled = false;
      StoneGap.readOnly = false;
      StoneGap.style.backgroundColor = 'window';
      StoneGapUnits.disabled = false;
   }
}



// === OnCreate ====================================
//
// Called when user presses create button to make pave plate
//

function OnCreate()
{
   // check we have the data we need ....
   var error_msg = '';

   var stone_dia = StoneDia.getValue();
   if (stone_dia <= 0.0)
      error_msg += gInvalidStoneDia;

   var bead_dia = BeadDia.getValue();
   if (bead_dia <= 0.0)
      error_msg += gInvalidBeadDia;

   var stone_gap = StoneGap.getValue();
   if (stone_gap < 0.0)
      error_msg += gInvalidStoneGap;

   var num_rows = NumRows.getValue();
   var num_columns = NumColumns.getValue();
   if (PaveAreaRadio[0].checked && (artcam.VectorSelection.IsEmpty()))
   {
      // defining area with vectors and none selected
      error_msg += gNoVectorSelected;
   }
   else
   {
      if (num_rows <= 0.0)
         error_msg += gInvalidNumRows;
      if (num_columns <= 0.0)
         error_msg += gInvalidNumColumns;
   }

   if (error_msg != '')
   {
      error_msg = gError + error_msg;
      artcam.MessageBox(error_msg);
      return;
   }

   // Remember the selected vector so that we can restore it's selected state afterwards - it's nice for trimming
   var curr_selection = artcam.VectorSelection.Selection;

   // save default page values - last calculated
   artcam.StoreString("PaveWizard","StoneDia", StoneDia.value);
   artcam.StoreString("PaveWizard","BeadDia",  BeadDia.value);
   artcam.StoreString("PaveWizard","StoneGap", StoneGap.value);
   artcam.StoreString("PaveWizard","NumRows", NumRows.value);
   artcam.StoreString("PaveWizard","NumColumns", NumColumns.value);

   artcam.StoreString("PaveWizard","PaveType", PaveTypeRadio[0].checked ? "0" : "1");
   artcam.StoreString("PaveWizard","BeadOrGap", BeadDiaOrGapRadio[0].checked ? "0" : "1");

   // we have the raw data we need, create the Pav
   globalStore.PaveAssistant.OnCreate(stone_dia, bead_dia, stone_gap, num_rows, num_columns,
      PaveTypeRadio[0].checked, BeadDiaOrGapRadio[0].checked, PaveAreaRadio[0].checked, gPaveUndo);

   // Restore the selection to the object that the Pav was created around
   artcam.VectorSelection.Selection = curr_selection;
}


// === OnSelectStones ============================================
//
// Select last group of stones we created
//
function OnSelectStones()
{
   return globalStore.PaveAssistant.OnSelectStones();
}

// === OnSelectBeads ============================================
//
// Select last group of beads we created
//
function OnSelectBeads()
{
   return globalStore.PaveAssistant.OnSelectBeads();
}


function OnSelectAll()
{
   return globalStore.PaveAssistant.OnSelectAll();
}


function OnTrim()
{
   // We must have one selected vector for the trimming.
   if( artcam.VectorSelection.Count != 1 )
   {
      artcam.MessageBox(gOneSelectedVector);
      return;
   }

   var trim_vector = artcam.SelectedVectorID;

   // Check that we have pav vectors to trim
   if ( OnSelectAll() == 0 )
   {
      artcam.MessageBox(gNoVectors);
      return;
   }

   globalStore.PaveAssistant.OnTrim(trim_vector, gTrimButton, gTrimVectorOpen);
}


function OnAccept()
{
   // Firstly make the stones into Gems
   MakeStonesIntoGems();

   // Remove flag marker from all beads
   OnSelectBeads();
   for (var idx=0; idx < artcam.VectorSelection.Count; idx++)
   {
      var vector = artcam.VectorSelection.Item(idx);
      if ( vector.FlagExists("bead") )
         vector.DeleteValue("bead");
   }

   artcam.VectorSelection.Selection = "";

   // Now leave this page
   OnBackButton();
}


function OnBack()
{
   // Delete all Stones and beads
   OnDelete();

   // Now leave this page
   OnBackButton();
}



function MakeStonesIntoGems(curr_stones)
{
   // Make a new Gem
   var gem = new Gem();
   gem.Width  = StoneDia.getValue();
   gem.Length = StoneDia.getValue();
   gem.Depth  = gem.Width * 0.42; // This is close to a brilliant
   gem.Shape  = "Round";

   var gemshape_library_path = artcam.HtmlRootDir + "../GemLibrary/GemColours";
   var index = ColourCombo.selectedIndex;
   var colour_path = gemshape_library_path + "/" + ColourCombo.options[index].text + ".txt";

   var file_browser = artcam.CreateFileSelector();
   var file_text = file_browser.ReadTextFile(colour_path);
   if( file_text == "" )
      return false;

   // Loop through the lines of the text file and find the first line that contains a paf description using a regexp
   var lines = file_text.split("\n");
   var line;
   for (line in lines)
   {

      // . Match Any character
      // + 1 or more times
      // ? Match as little as possible
      // () Grab out to $1
      // \s Match any space character
      // * 0 or more times
      // = Match '=' character

      if( /^\s*(.+?)\s*=\s*(.+?)\s*$/.test( lines[line] ) )
      {
         switch(RegExp.$1)
         {
         case "DiffuseRed":
            gem.DiffuseRed = parseInt(RegExp.$2);
            break;
         case "DiffuseGreen":
            gem.DiffuseGreen = parseInt(RegExp.$2);
            break;
         case "DiffuseBlue":
            gem.DiffuseBlue = parseInt(RegExp.$2);
            break;
         case "AmbientRed":
            gem.AmbientRed = parseInt(RegExp.$2);
            break;
         case "AmbientGreen":
            gem.AmbientGreen = parseInt(RegExp.$2);
            break;
         case "AmbientBlue":
            gem.AmbientBlue = parseInt(RegExp.$2);
            break;
         }
      }
   }

   // Get the Gem Vector Layer index
   var layer_index = gem.GetGemVectorLayer();

   // Select all the stones
   OnSelectStones();
   for (var idx=0; idx < artcam.VectorSelection.Count; idx++)
   {
      var vector = artcam.VectorSelection.Item(idx);
      if( vector.FlagExists("stone") )
      {
         // Remove the Stone Flag and change its layer to the gem layer.
         vector.DeleteValue("stone");
         vector.Layer = layer_index;

         // Now set the gem information in it
         gem.Name = "Pav " + (idx+1);
         //this.XPosition = 0;
         //this.YPosition = 0;
         gem.StoreInfoInVectorObject(vector);
      }
   }
}

function OnDelete()
{
   // Delete all Stones and beads
   globalStore.PaveAssistant.OnDelete(gDeleteButton);
}
