//================================================================
//
//@doc EXTERNAL
//
//@module api.js   | Javascript API for ArtCAM
//
//

// ----------------------------------------------------------------------------
// COPYRIGHT 1999 DELCAM PLC., BIRMINGHAM, ENGLAND. 
// ----------------------------------------------------------------------------
//
// History.
// Who When     What   
// --- -------- ---------------------------------------------------------
// tpb 08/12/99 Written
// tpb 29/05/07 Added GetTickCount and Timer functions
//-----------------------------------------------------------------------------


// Set artcam to be the external interface, we use the topmost document window
// as that is the one that is attached.
var artcam = top.external;


// Record script errors using ArtCAM's event log.
window.onerror = function(msg, url, line)
{
   return artcam.RecordScriptError(msg, url, line);
}


// Set our locale method - we will just pass strings straight into ArtCAM then write them into the document.
// We can pass string literals OR our current atext variables at the moment.
// All of our variables will be wrapped with _lc(*) now.
function _lc(str)
{
   return unescape(artcam.LocalizeString(str));
}

// Global write functions
var w = document.write;
var wl = document.writeln;

// We override parseFloat and parseInt with our own artcam version so we can control it more fully
// and deal with unicode numbers which sometimes crop up on Japanese versions for example
function parseFloat(str) { return artcam.parseFloat(str); }
function parseInt(str)   { return artcam.parseInt(str); }

function GetTickCount()  { return (new Date()).valueOf(); }
function RESET_TIMER()   { wuTimer_tickCount = GetTickCount(); }
function REPORT_TIMER()  { return GetTickCount() - wuTimer_tickCount; }

// Disable dragging on all pages
document.ondragstart = new Function("return false")

// Constants used.
//var COLOR_SCROLLBAR           = 0
//var COLOR_BACKGROUND          = 1
//var COLOR_ACTIVECAPTION       = 2
//var COLOR_INACTIVECAPTION     = 3
//var COLOR_MENU                = 4
//var COLOR_WINDOW              = 5
//var COLOR_WINDOWFRAME         = 6
//var COLOR_MENUTEXT            = 7
var COLOR_WINDOWTEXT          = 8
//var COLOR_CAPTIONTEXT         = 9
//var COLOR_ACTIVEBORDER        = 10
//var COLOR_INACTIVEBORDER      = 11
//var COLOR_APPWORKSPACE        = 12
var COLOR_HIGHLIGHT           = 13
var COLOR_HIGHLIGHTTEXT       = 14
var COLOR_BTNFACE             = 15
var COLOR_BTNSHADOW           = 16
//var COLOR_GRAYTEXT            = 17
//var COLOR_BTNTEXT             = 18
//var COLOR_INACTIVECAPTIONTEXT = 19
var COLOR_BTNHIGHLIGHT        = 20


// Variables for the ResponseMessageBox
var MB_OK                = 0x00;
var MB_OKCANCEL          = 0x01;
var MB_ABORTRETRYIGNORE  = 0x02;
var MB_YESNOCANCEL       = 0x03;
var MB_YESNO             = 0x04;
var MB_RETRYCANCEL       = 0x05;
var MB_CANCELTRYCONTINUE = 0x06;
var MB_ICONHAND          = 0x10;
var MB_ICONQUESTION      = 0x20;
var MB_ICONEXCLAMATION   = 0x30;
var MB_ICONASTERISK      = 0x40;
var MB_USERICON          = 0x80;
var MB_ICONWARNING       = MB_ICONEXCLAMATION;
var MB_ICONERROR         = MB_ICONHAND;
var MB_ICONINFORMATION   = MB_ICONASTERISK;
var MB_ICONSTOP          = MB_ICONHAND;

// ResponseMessageBox return values:
var IDOK     = 1;
var IDCANCEL = 2;
var IDABORT  = 3;
var IDRETRY  = 4;
var IDIGNORE = 5;
var IDYES    = 6;
var IDNO     = 7;
var IDCLOSE  = 8;
var IDHELP   = 9;

                            
// tpb 26/02/02 Timeout function for setting the header title and image
// ejp 04/03/04 Hide and show the title text - forces re-paint to fully clear previous text
// tpb 25/01/08 Title also set in top.document for easy querying from ArtCAM
g_headertimeoutcount = 0;
function SetHeaderTitle(title, imagesrc)
{
   // Ensure the outermost frame has the title set so that it can easily be queried from ArtCAM
   top.document.title = title;

   if( parent.header != null && parent.header.titleText != null && parent.header.titleImage != null)
   {
      g_headertimeoutcount = 0;
      parent.header.titleText.style.display="none";
      parent.header.titleText.innerHTML = title;
      parent.header.titleImage.src      = imagesrc;
      parent.header.titleText.style.display="";
   }
   else
   {
      g_headertimeoutcount++;
      
      // We keep trying for a whole second
      if( g_headertimeoutcount < 200 )
         setTimeout( "SetHeaderTitle('" + title + "', '" + imagesrc + "')", 50 );
      else
         g_headertimeoutcount = 0;
   }
}


//=== SetTheCharSet ==============================================
//
// Set the charset from the 'charset.atext' file in the translation
// directory. This file is needed if we are displaying chinese, 
// japanese etc on a non-native machine
//
//

// History
// Who When     What
// --- -------- ---------------------------------------------------------
// sap 21/11/02 Written
// tpb 25/11/02 Added error checking - caught problem with jscript changing
//              shift-js to shift_js
// sap 21/03/03 check we can still get at artcam
//-----------------------------------------------------------------------
function SetTheCharSet()
{
   if ( top.external == null )
      return;
   var file_browser;

   try
   {
      file_browser = top.external.CreateFileSelector();
   }
   catch(e)
   {
      return;
   }

   if ( file_browser != null )
   {
      var filepath = artcam.HtmlLangDir + "charset.atext"
      var charset_file = file_browser.ReadTextFile( filepath );

      if ( charset_file != "" )
      {
         try
         {
            eval( charset_file );
         }
         catch(e)
         {
            // If there was a script error in the file, warn the translator
            artcam.MessageBox("There was a script error in '"+filepath+"'\n\n" +
                              "Unable to change the charset: " + e.description );
            return;
         }

         // Now change the charset if it differs
         if ( document.charset != gCharset )
         {
            // This always throws an error but still works.
            // We catch the error and continue.
            // I think it is because it is worried about there being two charsets
            // on the document, but the reload sorts that out.
            try{document.charset = gCharset;}catch(e){} 
            
            // If we failed to set it warn the translator
            // otherwise reload the page
            if(document.charset != gCharset)
               artcam.MessageBox("gCharset name in '"+filepath+"' is currently '"+gCharset+"' " +
                                 "but should be changed to '"+document.charset+"'");
            else
               location.reload();
         }
      }
   }
}

SetTheCharSet();