//================================================================
//
// StandardToolpathFields.js   
//
// Implementation of the 'standard' toolpath fields such as
// Start Depth:, Finish Depth: etc.
//

// ----------------------------------------------------------------------------
// COPYRIGHT 2000 DELCAM PLC., BIRMINGHAM, ENGLAND. 
// ----------------------------------------------------------------------------
//
// History.
// Who When       What   
// --- ---------- ---------------------------------------------------------
// bem 23/05/2001 Written
// ejp 28/08/2002 Replaced insertCell() to avid IE6 bug
//-----------------------------------------------------------------------------


// === InitialiseStandardField =======================
//
// Write contents of table row used to hold 
// label, edit field and help (help is independent row)
//
function InitialiseStandardField
           (
           field_row_id,
           field_label,
           field_edit_name,
           help_row_id,
           help_text
           )
{
   var html;
   html  = "<b>" + field_label + "</b>"; 
   //var new_td = field_row_id.insertCell();
   var new_td = document.createElement("<td></td>");
   field_row_id.appendChild(new_td);

   if (new_td != null)
      new_td.innerHTML = html

   html = "<input id='" + field_edit_name + "' size=5 maxLength=8 value='0' number>";
   //new_td = field_row_id.insertCell();
   new_td = document.createElement("<td></td>");
   field_row_id.appendChild(new_td);

   if (new_td != null)
      new_td.innerHTML = html

   // now help - if required
   if (help_row_id != null)
      {
       //var new_td = help_row_id.insertCell();
       new_td = document.createElement("<td></td>");
       help_row_id.appendChild(new_td);


      if (new_td != null)
         {
         new_td.colSpan = 2;
         new_td.innerHTML = help_text
         }
      }
}

// === InitialiseStartDepthRow =======================
//
function InitialiseStartDepthRow(row_id,help_row_id)
{
InitialiseStandardField(
                       row_id,
                       gStartDepthFieldName,
                       'jStartDepthEdit',
                       help_row_id,
                       gStartDepthHelpText
                       );

}

// === InitialiseFinishDepthRow =======================
//
function InitialiseFinishDepthRow(row_id,help_row_id)
{
InitialiseStandardField(
                       row_id,
                       gFinishDepthFieldName,
                       'jFinishDepthEdit',
                       help_row_id,
                       gFinishDepthHelpText
                       );

}


// === InitialiseAllowanceRow =======================
//
function InitialiseAllowanceRow(row_id,help_row_id)
{
InitialiseStandardField(
                       row_id,
                       gAllowanceFieldName,
                       'jAllowanceEdit',
                       help_row_id,
                       gAllowanceHelpText
                       );


}

// === InitialiseFinalToolAllowanceRow =======================
//
function InitialiseFinalToolAllowanceRow(row_id,help_row_id)
{
InitialiseStandardField(
                       row_id,
                       gFinalToolAllowanceFieldName,
                       'jFinalToolAllowanceEdit',
                       help_row_id,
                       gFinalToolAllowanceHelpText
                       );


}


// === InitialiseSafeZ =======================
//
function InitialiseSafeZRow(row_id,help_row_id)
{
InitialiseStandardField(
                       row_id,
                       gSafeZFieldName,
                       'jSafeZEdit',
                       help_row_id,
                       gSafeZHelpText
                       );
}


// === InitialiseTolerance =======================
//
function InitialiseToleranceRow(row_id,help_row_id)
{
InitialiseStandardField(
                       row_id,
                       gToleranceFieldName,
                       'jToleranceEdit',
                       help_row_id,
                       gToleranceHelpText
                       );
}

// === Initialise3DAllowance =======================
//
function Initialise3DAllowance(row_id,help_row_id)
{
InitialiseStandardField(
                       row_id,
                       g3DAllowanceFieldName,
                       'j3DAllowanceEdit',
                       help_row_id,
                       g3DAllowanceHelpText
                       );
}

// === InitialiseRasterAngleRow =======================
//
function InitialiseRasterAngleRow(row_id,help_row_id)
{
InitialiseStandardField(
                       row_id,
                       gRasterAngleFieldName,
                       'jRasterAngleEdit',
                       help_row_id,
                       gRasterAngleHelpText
                       );
}

// === InitialiseHomePositionRows =======================
//
function InitialiseHomePositionRows(row_idX,row_idY,row_idZ,help_row_id)
{
   var html;

   // ---- X ----
   //var new_td = row_idX.insertCell()
   var new_td = document.createElement("<td></td>");
   row_idX.appendChild(new_td);
   if (new_td == null)
      return;

   html  = "<table width=100% cellspacing=0 border=0><tr>";
   html += "<td><b>" + gHomePositionFieldName + "</b></td><td align=right><b>X:</b></td>"; 
   html += "</tr></table>";

   new_td.innerHTML = html

   html = "<td><input id='" + 'jHomePositionXEdit' + "' size=5 maxLength=6 value='0' number></td>";

   //new_td = row_idX.insertCell()
   new_td = document.createElement("<td></td>");
   row_idX.appendChild(new_td);
   if (new_td != null)
      new_td.innerHTML = html

   // ---- Y ----
   //new_td = row_idY.insertCell()
   new_td = document.createElement("<td></td>");
   row_idY.appendChild(new_td);
   if (new_td == null)
      return;

   new_td.align='right'; 
   html = "<b>Y:</b>"; 
   new_td.innerHTML = html

   html = "<td><input id='" + 'jHomePositionYEdit' + "' size=5 maxLength=6 value='0' number></td>";
   //new_td = row_idY.insertCell()
   new_td = document.createElement("<td></td>");
   row_idY.appendChild(new_td);
   if (new_td != null)
      new_td.innerHTML = html

   // ---- Z ----
   if (row_idZ != null)
      {
      //new_td = row_idZ.insertCell()
      new_td = document.createElement("<td></td>");
      row_idZ.appendChild(new_td);
      if (new_td == null)
         return;
      html = "<b>Z:</b>";
      new_td.align='right'; 
      new_td.innerHTML = html

      html = "<td><input id='" + 'jHomePositionZEdit' + "' size=5 maxLength=6 value='0' number onBlur=GetHomePositionZ()></td>";
      //new_td = row_idZ.insertCell()
      new_td = document.createElement("<td></td>");
      row_idZ.appendChild(new_td);
      if (new_td != null)
         new_td.innerHTML = html
      }

   // --- Help -----------------
   if (help_row_id != null)
      {
      //new_td = help_row_id.insertCell()
      new_td = document.createElement("<td></td>");
      help_row_id.appendChild(new_td);
      if (new_td == null)
         return;
      new_td.colSpan = 2;
      new_td.innerHTML = gHomePositionHelpText;
      }
}

function CreateSafeZBlock(td_id,do_home_pos,do_tolerance)
{

// create a td
var html = "<table width=100% border=0 cellspacing=0>";

   html += 
   // Thin HR
   "<tr><td colspan=2 height=2px></td></tr>" +
   "<tr><td colspan=2 bgcolor=buttonshadow></td></tr>" +
   "<tr><td colspan=2 bgcolor=buttonhighlight></td></tr>" +
   "<tr><td colspan=2 height=2px></td></tr>" +

   "  <tr id='jSafeZSummary' bgcolor=" + artcam.GetSystemColourShadeString(COLOR_BTNFACE,2,COLOR_BTNSHADOW,1) + ">" +
   "    <td colspan=2 onclick=onjHomePosUpDownClick()>" +
   "        <img id='OpenCloseButton'align=right src= '" + artcam.HtmlRootDir() + "..\\SharedImages\\open_down_small_blue.gif'>" +
   "     <b>" + gSafeZHeadingName + "</b>" +
   "        <span id='jSafeZSummaryText'></span>" +
   "  </tr>" + 
   "  <tr id=jSafeZRow style='display:none'>" +
   "    <td><b>" + gSafeZFieldName + "</b></td>" +
   "    <td>" +
   //"       <img style='margin-left:4px' align=right src= '" + artcam.HtmlRootDir() + "..\\SharedImages\\close_up_small_grey.gif' >" +
   "       <input id='jSafeZEdit' size=5 maxLength=6 value='0' number onBlur=GetHomePositionZ()>&nbsp;" +
   "    </td>" +
   "  </tr>" +
   "  <tr id=jSafeZHelpRow HELPTAG style='display:none'>" +
   "    <td colspan=2>" + gSafeZHelpText + "</td>" +
   "  </tr>";

if (do_home_pos)
   {
   html +=
   "  <tr id='jHomePositionSummary'>" +
   "    <td><b>" + gHomePositionFieldName + "</b></td>" +
   "    <td id='jHomePositionSummaryText'></td>" +
   "  </tr>" + 
   "  <tr id=jHomePositionXRow style='display:none'> </tr>" +
   "  <tr id=jHomePositionYRow style='display:none'> </tr>" +
   "  <tr id=jHomePositionZRow style='display:none'> </tr>" +
   "  <tr id=jHomePositionHelpRow HELPTAG style='display:none'> </tr>" 
   }

if (do_tolerance)
   {
   html +=
   "  <tr id='jToleranceSummary'>" +
   "    <td><b>" + gToleranceFieldName + "</b></td>" +
   "    <td id='jToleranceSummaryText'></td>" +
   "  </tr>" + 
   "  <tr id=jToleranceRow style='display:none'> </tr>" +
   "  <tr id=jToleranceHelpRow HELPTAG style='display:none'> </tr>" 
   }

html += "</table>";

td_id.innerHTML = html;

if (do_home_pos)
   {
   InitialiseHomePositionRows(
                             jHomePositionXRow,
                             jHomePositionYRow,
                             jHomePositionZRow,
                             jHomePositionHelpRow
                             );
   }
if (do_tolerance)
   {
   InitialiseToleranceRow(jToleranceRow,jToleranceHelpRow)
   }
}

// === onjHomePosUpDownClick ===============
//
function onjHomePosUpDownClick()
{
//ToggleVisibility(jSafeZSummary);
      if(jHomePositionSummary.style.display == "none" )
         {
         OpenCloseButton.src = artcam.HtmlRootDir() + "..\\SharedImages\\open_down_small_blue.gif";
         }
      else
         {
         OpenCloseButton.src = artcam.HtmlRootDir() + "..\\SharedImages\\close_up_small_blue.gif";
         }

ToggleVisibility(jSafeZRow);

if (typeof(jHomePositionSummary) != 'undefined')
   {
   ToggleVisibility(jHomePositionSummary);
   ToggleVisibility(jHomePositionXRow);
   ToggleVisibility(jHomePositionYRow);
   ToggleVisibility(jHomePositionZRow);
   }

if (typeof(jToleranceSummary) != 'undefined')
   {
   ToggleVisibility(jToleranceSummary);
   ToggleVisibility(jToleranceRow);
   }
 
UpdateSafeZBlock();

}

// === GetStartDepth =======================
//
// Depths have to be positive
//
function GetStartDepth()
{
var value = jStartDepthEdit.getValue();
if (value < 0.0)
   {
   value *= -1.0;
   jStartDepthEdit.setValue(value);
   }
return value;
}

// === SetStartDepth =======================
//
function SetStartDepth(value)
{
// ensure not -ve 
if (value < 0.0)
   value *= -1.0;

jStartDepthEdit.setValue(value);
}

// === GetFinishDepth =======================
//
function GetFinishDepth()
{
var value = jFinishDepthEdit.getValue();
if (value < 0.0)
   {
   value *= -1.0;
   jFinishDepthEdit.setValue(value);
   }
return value;

}

// === SetFinishDepth =======================
//
function SetFinishDepth(value)
{
// ensure not -ve 
if (value < 0.0)
   value *= -1.0;

jFinishDepthEdit.setValue(value);
}

// === GetAllowance =======================
//
function GetAllowance()
{
return jAllowanceEdit.getValue();
}

// === SetAllowance =======================
//
function SetAllowance(value)
{
jAllowanceEdit.setValue(value);
}

// === GetFinalToolAllowance =======================
//
function GetFinalToolAllowance()
{
return jFinalToolAllowanceEdit.getValue();
}

// === SetFinalToolAllowance =======================
//
function SetFinalToolAllowance(value)
{
jFinalToolAllowanceEdit.setValue(value);
}


// === GetSafeZ =======================
//
function GetSafeZ()
{
return jSafeZEdit.getValue();
}

// === setSafeZ =======================
//
function SetSafeZ(value)
{
   jSafeZEdit.setValue(value);
   var home_z = jHomePositionZEdit.getValue();
   if(home_z<value)
      jHomePositionZEdit.setValue(value);
   UpdateSafeZSummary();
   UpdateHomePositionSummary();
}

// === UpdateSafeZSummary =======================
//
function UpdateSafeZSummary()
{
if (typeof(jSafeZSummaryText) == 'undefined')
   return;

if(jHomePositionSummary.style.display == "none")
   {
   jSafeZSummaryText.innerHTML = "";
   }
else
   {
   var text = "<b>: </b>" + jSafeZEdit.getValue() + " " + Units();
   jSafeZSummaryText.innerHTML = text;
   }
}


// === GetTolerance =======================
//
function GetTolerance()
{
return jToleranceEdit.getValue();
}

// === SetTolerance =======================
//
function SetTolerance(value)
{
jToleranceEdit.setValue(value);
UpdateToleranceSummary();
}

// === UpdateToleranceSummary =======================
//
function UpdateToleranceSummary()
{
if (typeof(jToleranceSummaryText) == 'undefined')
   return;
var text = jToleranceEdit.value;
text += ' ';
text += Units();
jToleranceSummaryText.innerHTML=text;
}

// === Get3DAllowance =======================
//
function Get3DAllowance()
{
return j3DAllowanceEdit.getValue();
}

// === Set3DAllowance =======================
//
function Set3DAllowance(value)
{
j3DAllowanceEdit.setValue(value);
}

// === GetRasterAngle =======================
//
function GetRasterAngle()
{
return jRasterAngleEdit.getValue();
}

// === SetRasterAngle =======================
//
function SetRasterAngle(value)
{
jRasterAngleEdit.setValue(value);
}

// === GetHomePositionX =======================
//
function GetHomePositionX()
{
return jHomePositionXEdit.getValue();
}

// === SetHomePositionX =======================
//
function SetHomePositionX(value)
{
jHomePositionXEdit.setValue(value);
}


// === GetHomePositionY =======================
//
function GetHomePositionY()
{
return jHomePositionYEdit.getValue();
}

// === SetHomePositionY =======================
//
function SetHomePositionY(value)
{
jHomePositionYEdit.setValue(value);
}

// === GetHomePositionZ =======================
//
function GetHomePositionZ()
{
var safe_z  = jSafeZEdit.getValue();
var z_value = jHomePositionZEdit.getValue();

if(z_value<safe_z)
   jHomePositionZEdit.setValue(safe_z);

return jHomePositionZEdit.getValue();
}

// === SetHomePositionZ =======================
//
function SetHomePositionZ(value)
{
var safe_z = jSafeZEdit.getValue();
if(value>safe_z)
   jHomePositionZEdit.setValue(value);
else
   jHomePositionZEdit.setValue(safe_z);
}

// === UpdateHomePositionSummary =======================
//
function UpdateHomePositionSummary()
{
if (typeof(jHomePositionSummaryText) == 'undefined')
   return;

var safe_z = jSafeZEdit.getValue();
var home_z = jHomePositionZEdit.getValue();
if(home_z<safe_z)
   jHomePositionZEdit.setValue(safe_z);

var text  = "X:" + jHomePositionXEdit.value;
   text += " Y:" + jHomePositionYEdit.value;
   text += " Z:" + jHomePositionZEdit.value;

jHomePositionSummaryText.innerText = text;

}


// === SetHomePosition =======================
//
function SetHomePosition(x_value,y_value,z_value)
{
jHomePositionXEdit.setValue(x_value);
jHomePositionYEdit.setValue(y_value);

var safe_z = jSafeZEdit.getValue();
if(z_value>safe_z)
   jHomePositionZEdit.setValue(z_value);
else
   jHomePositionZEdit.setValue(safe_z);

UpdateHomePositionSummary();
}


// === UpdateSafeZBlock =======================
//
function UpdateSafeZBlock()
{
UpdateSafeZSummary();
UpdateHomePositionSummary();
UpdateToleranceSummary();
}

// === GetToolpathName ===============================
//
// Return name for toolpath - set gToolpathId and gToolpathName
//

function GetToolpathName(default_name)
   { 
   // if the user hasnt supplied a name use default
   var toolpath_name = ToolpathNameEdit.value;
   if (toolpath_name == "")
      {
      // get a new 'unique' version of toolpath name
      toolpath_name = artcam.Machining.GetUniqueToolpathName(default_name);
      ToolpathNameEdit.value = toolpath_name;
      gToolpathId = "";
      gToolpathName = toolpath_name;
      }
   else
      {
      // if the name has changed from the original name we create a new toolpath
      if (gToolpathName != toolpath_name)
         {
         // we are creating a new toolpath - clear id record
         gToolpathId = "";
         gToolpathName = toolpath_name;
         }
      }
   return toolpath_name;
   }

// === DisplayToolpathInterfaceError ===================
//
// Display error indicating we failed to get correct 
// toolpath interface from ArtCAM

function DisplayToolpathInterfaceError()
{
 artcam.MessageBox(gToolpathInterfaceError);
}