// Calling page must have paramsDiv & libraryDiv objects for these functions
// show and manipulate
function plugin_main()
{
   // Hide the library div
   HideAllLibraryDivs();
   paramsDiv.style.display = "";
   paramsDiv.innerHTML = "";

   globalStore.OnBack = OnBack;
   globalStore.OnFinish = OnFinish;
   globalStore.OnBuild = OnBuild;

   globalStore.ActiveShank = new Shank();
   globalStore.ActiveShank.DefaultName=gDefaultName;
   globalStore.ActiveShank.UseForwardButton = true;
   globalStore.ActiveShank.CallbackFunction = OnGotShankParams;
   globalStore.ActiveShank.WriteParamsHTML(paramsDiv);
}

function Write_params(targetDiv)
{
   var hArr = new Array();
   // Add the back button HTML to the array

   hArr.push("<table width='100%' border=0 cellspacing=0 style='margin-left:3px'>");
   hArr.push("<colgroup><col width=40px><col width=30%><col width=40%></colgroup>");
   hArr.push("<tr HELPTAG style='display:none'><td colspan=3><img align=left src='" + artcam.HtmlRootDir + "../SharedImages/help.gif'>&nbsp;" + gFormHelp + "</td></tr>");
   hArr.push("<tr><td colspan=3>" + gInstructions + "</td></tr>");
   hArr.push("</table>");

   hArr.push("<div class='mouseOut' button_name='forward_button' id=ForwardButton targetFunction='globalStore.OnFinish' style='width=30px;float:right'>");
   hArr.push("<img alt =" + gAcceptButtonAlt + " id=forward_img src ='" + artcam.HtmlRootDir + "../SharedImages/accept.gif' align=absmiddle border=0 width=30 height=30>");
   hArr.push("</div>");

   hArr.push("<div class='mouseOut' button_name='rebuild_button' id=RebuildButton targetFunction='globalStore.OnBuild' style='width=30px;float:right'>");
   hArr.push("<img alt =" + gRebuildButtonAlt + " id=rebuild_img src ='" + artcam.HtmlRootDir + "../SharedImages/rebuild.gif' align=absmiddle border=0 width=30 height=30>");
   hArr.push("</div>");

   hArr.push("<div class='mouseOut' button_name='back_button' id=BackButton targetFunction='globalStore.OnBack' style='width=30px;float:right'>");
   hArr.push("<img alt =" + gBackButtonAlt + " id=back_img src ='" + artcam.HtmlRootDir + "../SharedImages/back.gif' align=absmiddle border=0 width=30 height=30>");
   hArr.push("</div>");

   targetDiv.innerHTML += hArr.join("\n");
   // Bung all our HTML into the div and display it
   InitialiseButtonDivs();
   SubclassNumberEditControls();
}

function OnCreatePlain()
{
   artcam.ProjectAssembly.SetFlag("BuildingFlag", CreateRotaryShankFromShankObject(globalStore.ActiveShank));
   if(false == artcam.ProjectAssembly.GetFlag("BuildingFlag", false))
   {
      return false;
   }

   artcam.CurrentModel.Rename(globalStore.ActiveShank.Name, false);

   var vector = artcam.Vectors.CreateVector();
   if (typeof(vector)!="object")
   {
      artcam.Alert("Failed to create vector",0);
      return false;
   }

   vector.MoveTo(-artcam.CurrentModel.RealWidth/2.0,globalStore.ActiveShank.Width/2);
   vector.LineTo(0,globalStore.ActiveShank.Width/2);
   vector.LineTo(artcam.CurrentModel.RealWidth/2.0,globalStore.ActiveShank.Width/2);
   artcam.Vectors.AddVectorToArtcam(vector);
   globalStore.Rail1ID = vector.VectorID;

   vector = artcam.Vectors.CreateVector();
   if (typeof(vector)!="object")
   {
      artcam.Alert("Failed to create vector",0);
      return false;
   }

   vector.MoveTo(-artcam.CurrentModel.RealWidth/2.0,-globalStore.ActiveShank.Width/2);
   vector.LineTo(0,-globalStore.ActiveShank.Width/2);
   vector.LineTo(artcam.CurrentModel.RealWidth/2.0,-globalStore.ActiveShank.Width/2);
   artcam.Vectors.AddVectorToArtcam(vector);
   globalStore.Rail2ID = vector.VectorID;

   globalStore.Middle_Profile_ID = DrawAngledProfile(globalStore.ActiveShank.Width, globalStore.ActiveShank.Thickness,82);
   globalStore.End_Profile_ID = DrawAngledProfile(globalStore.ActiveShank.Width, globalStore.ActiveShank.Thickness,82);
   artcam.SelectedVectorID = globalStore.End_Profile_ID;
   artcam.MoveVectors(-artcam.CurrentModel.RealWidth/2,0);

   globalStore.ZCurveID = DrawZModulationCurve(globalStore.ActiveShank.Thickness,globalStore.ActiveShank.Thickness);

   return OnBuild();
}

function OnFinish()
{
   SaveArtFile("Shank", globalStore.ActiveShank.Name);
   OnCloseAndGotoAssistantTab();
}

function OnBuild()
{
   artcam.Relief.SetAllHeights(artcam.Relief.BaseHeight);
   var temp_relief = artcam.CreateEmptyRelief();
   temp_relief.CopyFromCurrent();
   temp_relief.BaseHeight = 0;
   temp_relief.Reset();

   var sweep_info = artcam.CreateTwoRailSweepData();
   sweep_info.SetRail1(globalStore.Rail1ID);
   sweep_info.SetRail2(globalStore.Rail2ID);
   sweep_info.SetZModCurve(globalStore.ZCurveID);
   sweep_info.AddCrossSection(globalStore.End_Profile_ID,0,0,0.3,0.3,true);
   sweep_info.AddCrossSection(globalStore.Middle_Profile_ID,0.5,0.5,0.3,0.3,true);
   sweep_info.AddCrossSection(globalStore.End_Profile_ID,1,1,0.3,0.3,true);
   var min_x= artcam.Relief.MinX;
   var max_x= artcam.Relief.MaxX;
   var min_y= artcam.Relief.MinY;
   var max_y= artcam.Relief.MaxY;
   var cen_y = (min_y + max_y) / 2.0;
   sweep_info.UseLinearZModulation(min_x, cen_y, max_x, cen_y);
   sweep_info.ZModCurveIsAbsolute = true;
   sweep_info.ZModCurveIsWrapped = true;

   artcam.TwoRailSweep(sweep_info, temp_relief);
   temp_relief.MergeHighestWithCurrent();

   var RingDesigner = artcam.CreateRingDesigner();
   RingDesigner.PatchSweepRoundingError();
   return true;
}

function OnGotShankParams(completed)
{
   if(completed)
   {
      if (true == OnCreatePlain())
      {
         paramsDiv.innerHTML = "";
         Write_params(paramsDiv);
      }
   }
   else
   {
      OnBackButton();
   }
}

function OnBack()
{
   var currTab = artcam.CurrentTab;
   OldOnModelClosed = OnModelClosed;
   OnModelClosed = function() {};
   artcam.ForceModelClose();
   OnModelClosed = OldOnModelClosed;
   artcam.CurrentTab = currTab;
   paramsDiv.innerHTML = "";
   globalStore.ActiveShank.WriteParamsHTML(paramsDiv);
}

function OnModelClosed()
{
   if (true == artcam.ProjectAssembly.GetFlag("BuildingFlag", false))
   {
      OnClose();
   }
}
