// Calling page must have paramsDiv & libraryDiv objects for these functions
// show and manipulate

function plugin_main()
{
   // Hide the library div
   HideAllLibraryDivs();
   write_params(paramsDiv);               // Maybe not neccessary

   // Hook into the selection change mechanism and call it to set the page in the right state
   globalStore.OnVectorSelectionChanged = OnVectorSelectionChanged;
   globalStore.OnVectorSelectionChanged();
}

function write_params(targetDiv)
{
   targetDiv.innerHTML = "";
   //InitialiseButtonDivs();
   //SubclassNumberEditControls();
}

function GemCallback(completed)
{
   if(!completed)
   {
      OnBackButton();
      return;
   }

   if( artcam.VectorSelection.Count != 1 )
   {
      // Do nothing, this shouldn't have happened
      return;
   }
    
   // Get the GemVector
   var vector = artcam.VectorSelection.Item(0);

   // Get the Vector Layer index and move the vector to it
   var layer_index = globalStore.ActiveGem.GetGemVectorLayer();
   if( artcam.VectorLayers.IsValid(layer_index) )
      vector.Layer = layer_index;

   // Get the vector width and height
   var vector_width  = vector.MaxX - vector.MinX;
   var vector_height = vector.MaxY - vector.MinY;
      
   // Set the size from the vector if requested
   if(globalStore.ActiveGem.SizeSetFromVector)
   {
      globalStore.ActiveGem.Width  = vector_width;
      globalStore.ActiveGem.Length = vector_height;
      globalStore.ActiveGem.Depth  = globalStore.ActiveGem.Width * 0.42; // This is close to a brilliant
   }

   // Need to override the height width if we are taking it from the vector
   globalStore.ActiveGem.InitialAngleReference = globalStore.ActiveGem.GetReferenceAngle(vector);
   globalStore.ActiveGem.StoreInfoInVectorObject(vector);

   // Transform the vector?
   // If we have certain variables set then we have to transform the vectors after drawing
   //artcam.TransformVectorsAnchorCopy(globalStore.ActiveGem.XPosition,
   //                                  globalStore.ActiveGem.YPosition, // Position
   //                                  globalStore.ActiveGem.Width / vector_width, 
   //                                  globalStore.ActiveGem.Length / vector_height, // Scale
   //                                  0.0,      // Angle (Rad)
   //                                  0.0, 0.0, // Shear
   //                                  0.0, 0.0, // About point
   //                                  false);   // Make a copy

   // Allow to change the shape?
   
   artcam.Refresh2dView();
   OnBackButton();
}


function OnVectorSelectionChanged()
{
   // Make a new Gem
   var gem = globalStore.ActiveGem = new Gem();
   gem.SizeFromVectorOption = true;
   gem.AddColourChangeButton = true;
   gem.TargetDiv = gemsDiv;
   gem.CallingDiv = paramsDiv;
   gem.CallbackFunction = GemCallback;

   // Make sure the right things are showing
   gemsDiv.style.display = "";
   paramsDiv.style.display = "none";

   // Get the currently selected vector and retrieve the info from it...
   if( artcam.VectorSelection.Count == 1 )
   {
      var vector = artcam.VectorSelection.Item(0);
      if( vector.IsContour )
      {
         gem.RetrieveInfoFromVectorObject(vector); // Get the gem info from the vector
         if( gem.Shape != "" )
         {
            // If we have retrieved information from the vector then we setup the gem and build up the param's page
            gem.WriteParamsSelectionHTML("");
            gem.PreviousPage = "";
            gem.NextPage = "";

            //forward_button.src = artcam.HtmlRootDir + "../SharedImages/back.gif";
            return;
         }
      }
   }

   // If we get here then there was no valid gem vector selected. We show a warning.
   var html = new Array();
   html.push("<b>"+gSelectHelp+"</b>");

   // Add back button
   html.push("<div class='mouseOut' button_name='back_button' targetFunction='globalStore.ActiveGem.OnBackButton' style='width=30px;float:right;'>");
   html.push("<img alt =" + gBackButtonAlt + " id=back_img src ='" + artcam.HtmlRootDir + "../SharedImages/back.gif' align=absmiddle border=0 width=30 height=30>");
   html.push("</div>");
   
   gemsDiv.innerHTML = html.join("\n");
   
   // initialise all the 'special' objects
   InitialiseButtonDivs();
   SubclassNumberEditControls();
}
