<?php
// setup includes
require_once('../../core/includes/master.inc.php');

// require login
$Auth->requireUser(WEB_ROOT.'/login.'.SITE_CONFIG_PAGE_EXTENSION);

// pickup variables
$width = (int)$_REQUEST['width'];
$height = (int)$_REQUEST['height'];
$userId = $Auth->id;
if(($width == 0) || ($height == 0))
{
	coreFunctions::output404();
}

// block memory issues
if(($width > 500) || ($height > 500))
{
	coreFunctions::output404();
}

// setup paths
$avatarCachePath = 'user/'.(int)$userId.'/profile';
$avatarCacheFilename = MD5((int)$userId.$width.$height.'square').'.jpg';

// check if user has cached avatar
if($fileContent = cache::getCacheFromFile($avatarCachePath.'/'.$avatarCacheFilename))
{
	header('Content-Type: image/jpeg');
	echo $fileContent;
	exit;
}

// check for original avatar image
if(!cache::getCacheFromFile($avatarCachePath.'/avatar_original.jpg'))
{
	// no avatar uploaded, output default icon
	$defaultIcon = file_get_contents(SITE_IMAGE_PATH.'/avatar_default.jpg');
    header('Content-Type: image/jpeg');
	echo $defaultIcon;
	exit;
}

// resize image to square thumbnail
list($ow, $oh) = getimagesize(CACHE_DIRECTORY_ROOT.'/'.$avatarCachePath.'/avatar_original.jpg');
$imageOriginal = imagecreatefromjpeg(CACHE_DIRECTORY_ROOT.'/'.$avatarCachePath.'/avatar_original.jpg');
$imageThumb = imagecreatetruecolor($width, $height);
if ($ow > $oh)
{
   $offW = ($ow-$oh)/2;
   $offH = 0;
   $ow = $oh;
}
elseif ($oh > $ow)
{
   $offW = 0;
   $offH = ($oh-$ow)/2;
   $oh = $ow;
}
else
{
   $offW = 0;
   $offH = 0;
}

imagecopyresampled($imageThumb, $imageOriginal, 0, 0, $offW, $offH, $width, $height, $ow, $oh);

// get content as variable so we can use the caching functions
ob_start();
imagejpeg($imageThumb, null, 100);
$imageData = ob_get_contents();
ob_end_clean();

// save cache
cache::saveCacheToFile($avatarCachePath.'/'.$avatarCacheFilename, $imageData);

// output image
header('Content-Type: image/jpeg');
echo $imageData;
exit;