<?php

// core plugin config
$pluginConfig                            = array();
$pluginConfig['plugin_name']             = 'Rewards Program';
$pluginConfig['folder_name']             = 'rewards';
$pluginConfig['plugin_description']      = 'Enable your users to make money by earning a percentage of referred paid upgrades or downloading files. (PPS/PPD)';
$pluginConfig['plugin_version']          = 8;
$pluginConfig['required_script_version'] = '4.0';
$pluginConfig['database_sql']            = 'offline/database.sql';

// plugin admin area settings, links are relative to the plugin root
// links in multi-dimentional arrays create sub-menus, first item in array is the top level
$pluginConfig['admin_settings']              = array();
$pluginConfig['admin_settings']['top_nav']   = array();
$pluginConfig['admin_settings']['top_nav'][] = array(
    array('link_url'  => '#', 'link_text' => 'Rewards', 'link_key'  => 'rewards'),
    array('link_url'  => 'admin/detailed_referral.php', 'link_text' => 'Referrals (pps)', 'link_key'  => 'rewards_detailed_referral'),
    array('link_url'  => 'admin/detailed_download.php', 'link_text' => 'Downloads (ppd)', 'link_key'  => 'rewards_detailed_download'),
    array('link_url'  => 'admin/aggregated_earning.php', 'link_text' => 'Aggregated Earnings', 'link_key'  => 'rewards_aggregated_earning'),
    array('link_url'  => 'admin/payment_request.php', 'link_text' => 'Payment Requests', 'link_key'  => 'rewards_payment_request')
);

// plugin front-end settings, links should be full paths. Use getCoreSitePath() for web root.
// use 'user_level_id' to show only for specific user account types (as an array). For a range of type ids use range(1, 20).
// user 'after_item' to set after existing navigation item. If blank it'll be added at the end.
$pluginConfig['site_settings']                       = array();
$pluginConfig['site_settings']['top_nav']            = array();
$pluginConfig['site_settings']['top_nav']['rewards'] = array(
    'link_url'      => coreFunctions::getCoreSitePath() . '/plugins/rewards/site/rewards.' . SITE_CONFIG_PAGE_EXTENSION,
    'on_click'      => '',
    'link_text'     => t('rewards', 'rewards'),
    'user_level_id' => array(0),
    'position'      => 250,
    'link_key'      => 'rewards'
);

$pluginConfig['site_settings']['top_nav']['rewards_logged_in'] = array(
    'link_url'      => coreFunctions::getCoreSitePath() . '/plugins/rewards/site/account_rewards.' . SITE_CONFIG_PAGE_EXTENSION,
    'on_click'      => '',
    'link_text'     => t('rewards', 'rewards'),
    'user_level_id' => range(1, 20),
    'position'      => 250, 
    'link_key'      => 'rewards_logged_in'
);
