<?php
// setup includes
require_once('../../../core/includes/master.inc.php');

// load plugin details
$pluginDetails  = pluginHelper::pluginSpecificConfiguration('mediaplayer');
$pluginConfig   = $pluginDetails['config'];
$pluginSettings = json_decode($pluginDetails['data']['plugin_settings'], true);
$pluginObj = pluginHelper::getInstance('mediaplayer');

// do not allow if embed options are disabled
if ((int) $pluginSettings['show_embed'] == 0)
{
    // embedding disabled
    coreFunctions::output404();
}

// try to load the file object
$file = null;
if (isset($_REQUEST['u']))
{
    $file = file::loadByShortUrl($_REQUEST['u']);
}

/* load file details */
if (!$file)
{
    /* if no file found, redirect to home page */
    coreFunctions::redirect(WEB_ROOT . "/index." . SITE_CONFIG_PAGE_EXTENSION);
}

// embed size
if (isset($_REQUEST['w']))
{
    $w = (int) $_REQUEST['w'];
}
if (isset($_REQUEST['h']))
{
    $h = (int) $_REQUEST['h'];
}
define("EMBED_WIDTH", $w ? $w : $pluginSettings['embed_video_size_w']);
define("EMBED_HEIGHT", $h ? $h : $pluginSettings['embed_video_size_h']);

// load available extensions for non_media_types user
$ext = explode("|", $pluginSettings['non_media_types']);

// if this is a download request
if (!in_array(strtolower($file->extension), $ext))
{
    // file not permitted
    coreFunctions::output404();
}

// setup database
$db = Database::getDatabase();

// get player
$mediaPlayer = $pluginConfig['players'][strtolower($file->extension)];
if ($mediaPlayer == 'jplayer_video')
{
    $mediaPlayer = 'html5_video';
}
elseif ($mediaPlayer == 'jplayer_audio')
{
    $mediaPlayer = 'html5_audio';
}

// which html5 player to use
$html5Player = $pluginSettings['html5_player'];
if (strlen($html5Player) == 0)
{
    $html5Player = 'jplayer';
}

// prepare trimmed header
$headerTitle = $file->originalFilename;
if (strlen($headerTitle) > 60)
{
    $headerTitle = substr($headerTitle, 0, 55) . '...' . end(explode(".", $headerTitle));
}

// for includes
$childFileObj = $file;
$originalFileObj = $file;
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <title><?php echo validation::safeOutputToScreen(PAGE_NAME); ?> - <?php echo SITE_CONFIG_SITE_NAME; ?></title>
        <meta name="description" content="<?php echo validation::safeOutputToScreen(PAGE_DESCRIPTION); ?>" />
        <meta name="keywords" content="<?php echo validation::safeOutputToScreen(PAGE_KEYWORDS); ?>" />
        <meta name="copyright" content="Copyright &copy; <?php echo date("Y"); ?> - <?php echo SITE_CONFIG_SITE_NAME; ?>" />
        <meta name="robots" content="all" />
        <meta http-equiv="Cache-Control" content="no-cache" />
        <meta http-equiv="Expires" content="-1" />
        <meta http-equiv="Pragma" content="no-cache" />
        <script type="text/javascript" src="<?php echo SITE_JS_PATH; ?>/jquery-1.11.0.min.js"></script>
        <style>
            body, html
            {
                background-color: #fff;
				padding: 0px;
				margin: 0px;
            }
			
            .embedded div.jp-audio div.jp-type-single div.jp-progress, .embedded div.jp-audio div.jp-type-single div.jp-time-holder
            {
                width: 65%;
            }

            .embedded div.jp-audio div.jp-volume-bar
            {
                right: 36px;
                left: auto !important;
            }

            .embedded div.jp-audio div.jp-type-single a.jp-mute, div.jp-audio div.jp-type-single a.jp-unmute
            {
                margin-left: <?php echo EMBED_WIDTH - 200; ?>px;
            }
			
			<?php if ((strlen($pluginSettings['html5_player_license_key']) == 0) && ($mediaPlayer == 'html5_audio')): ?>
			.embedded .jwlogo
			{
				display: none; /* hidden as sits over volume on mp3s */
			}
			<?php endif; ?>
        </style>
    </head>

    <body style="width: <?php echo EMBED_WIDTH; ?>px;">
        <div class="embedded">

            <?php if (in_array($mediaPlayer, array('html5_video', 'html5_audio'))): ?>
                <?php
                $jPlayerCat = $file->extension;
                $jwPlayerCat = $file->extension;
                switch ($file->extension)
                {
                    case 'mp4':
                        $jPlayerCat = 'm4v';
                        break;
                    case 'm4v':
                        $jwPlayerCat = 'mp4';
                        break;
                    case 'ogg':
                        $jwPlayerCat = 'webm';
                        break;
                    case 'webm':
                        $jPlayerCat = 'webmv';
                        break;
                }
                ?>

                <?php if ($html5Player == 'jplayer'): ?>
                    <!-- jplayer -->
                    <link href="<?php echo PLUGIN_WEB_ROOT; ?>/mediaplayer/assets/players/jplayer/skin/blue.monday/jplayer.blue.monday.css" rel="stylesheet" type="text/css" />
                    <script type="text/javascript" src="<?php echo PLUGIN_WEB_ROOT; ?>/mediaplayer/assets/players/jplayer/jquery.jplayer.min.js"></script>
                    <!-- end jplayer -->

                    <script type="text/javascript">
                        //<![CDATA[
                        $(document).ready(function() {
                            $("#jplayer_container").jPlayer({
                                ready: function() {
                                    $(this).jPlayer("setMedia", {
        <?php echo $jPlayerCat; ?>: "<?php echo $file->generateDirectDownloadUrlForMedia(); ?>"
                                    })<?php echo $pluginSettings['auto_play'] == 1 ? '.jPlayer("play")' : ''; ?>;

                                    $('body').keyup(function(e) {
                                        if (e.keyCode == 27)
                                        {
                                            $('#jplayer_container').data("jPlayer").restoreScreen();
                                        }
                                    });
                                },
                                swfPath: "<?php echo PLUGIN_WEB_ROOT; ?>/mediaplayer/assets/players/jplayer",
                                supplied: "<?php echo $jPlayerCat; ?>",
                                solution: "html, flash",
                                size: {
                                    width: "100%",
                                    height: "<?php echo $mediaPlayer == 'html5_video' ? EMBED_HEIGHT . 'px' : ''; ?>",
                                    cssClass: "<?php echo $mediaPlayer == 'html5_video' ? 'jp-video-360p' : 'jp-audio'; ?>"
                                }
                            });
                        });
                        //]]>
                    </script>
                <?php endif; ?>

                <?php if ($html5Player == 'jwplayer'): ?>
                    <!-- jwplayer -->
                    <script type="text/javascript" src="<?php echo PLUGIN_WEB_ROOT; ?>/mediaplayer/assets/players/jwplayer/jwplayer.js"></script>
                    <?php
                    if (isset($pluginSettings['html5_player_license_key']) && strlen($pluginSettings['html5_player_license_key']))
                    {
                        echo '<script type="text/javascript">jwplayer.key="' . validation::safeOutputToScreen($pluginSettings['html5_player_license_key']) . '";</script>';
                        echo "\n";
                    }
                    ?>
                    <!-- end jwplayer -->
                <?php endif; ?>
                    
                <?php if ($html5Player == 'jwplayer7'): ?>
                    <!-- jwplayer7 -->
                    <script type="text/javascript" src="<?php echo PLUGIN_WEB_ROOT; ?>/mediaplayer/assets/players/jwplayer7/jwplayer.js"></script>
                    <?php
                    if (isset($pluginSettings['html5_player_license_key']) && strlen($pluginSettings['html5_player_license_key']))
                    {
                        echo '<script type="text/javascript">jwplayer.key="' . validation::safeOutputToScreen($pluginSettings['html5_player_license_key']) . '";</script>';
                        echo "\n";
                    }
                    ?>
                    <!-- end jwplayer7 -->
                <?php endif; ?>
            <?php endif; ?>

            <div style="width: <?php echo EMBED_WIDTH; ?>px;">

                <?php if ($mediaPlayer == 'html5_video'): ?>

				    <?php
					// disable any ads since we're within the admin area
					$playerIncludePath = PLUGIN_DIRECTORY_ROOT.'mediaplayer/includes/_player_'.$mediaPlayer.'_'.$html5Player.'.inc.php';
					if(!file_exists($playerIncludePath))
					{
						echo "Error: ".$mediaPlayer." player for ".$html5Player." not found!";
					}
					else
					{
						include_once($playerIncludePath);
					}
					?>
					<?php endif; ?>

                <?php if ($mediaPlayer == 'html5_audio'): ?>

                    <?php
					$playerIncludePath = PLUGIN_DIRECTORY_ROOT.'mediaplayer/includes/_player_'.$mediaPlayer.'_'.$html5Player.'.inc.php';
					if(!file_exists($playerIncludePath))
					{
						echo "Error: ".$mediaPlayer." player for ".$html5Player." not found!";
					}
					else
					{
						include_once($playerIncludePath);
					}
					?>
					
                <?php endif; ?>

                <?php if ($mediaPlayer == 'divx_web_player'): ?>
                    <object classid="clsid:67DABFBF-D0AB-41fa-9C46-CC0F21721616"
                            width="100%" height="530"
                            codebase="http://go.divx.com/plugin/DivXBrowserPlugin.cab">
                        <param name="src" value="<?php echo $file->generateDirectDownloadUrlForMedia(); ?>"/>
                        <param name="autoPlay" value="<?php echo $pluginSettings['auto_play'] == 1 ? 'true' : 'false'; ?>"/>

                        <embed
                            type="video/divx"
                            src="<?php echo $file->generateDirectDownloadUrlForMedia(); ?>"
                            width="100%" height="530"
                            autoPlay="<?php echo $pluginSettings['auto_play'] == 1 ? 'true' : 'false'; ?>"
                            pluginspage="http://go.divx.com/plugin/download/">
                        </embed>
                    </object>
                <?php endif; ?>

                <?php if ($mediaPlayer == 'windows_media_player'): ?>
                    <object classid="CLSID:6BF52A52-394A-11d3-B153-00C04F79FAA6" id="player" width="100%" height="530">
                        <param name="url" value="<?php echo $file->generateDirectDownloadUrlForMedia(); ?>" />
                        <param name="src" value="<?php echo $file->generateDirectDownloadUrlForMedia(); ?>" />
                        <param name="showcontrols" value="true" />
                        <param name="autostart" value="<?php echo $pluginSettings['auto_play'] == 1 ? 'true' : 'false'; ?>" />
                        <!--[if !IE]>-->
                        <object type="video/x-ms-wmv" data="<?php echo $file->generateDirectDownloadUrlForMedia(); ?>" width="100%" height="530">
                            <param name="src" value="<?php echo $file->generateDirectDownloadUrlForMedia(); ?>" />
                            <param name="controller" value="true" />
                            <param name="autostart" value="<?php echo $pluginSettings['auto_play'] == 1 ? 'true' : 'false'; ?>" />
                        </object>
                        <!--<![endif]-->
                    </object>

                <?php endif; ?>

            </div>
        </div>
    </body>
</html>
