<?php
// pickup params
$file = $params['file'];
$Auth = $params['Auth'];
$isPublic = (int)$params['isPublic'];

if ($file->statusId == 1)
{
	// load plugin details
    $pluginDetails  = pluginHelper::pluginSpecificConfiguration('mediaplayer');
    $pluginConfig   = $pluginDetails['config'];
    $pluginSettings = json_decode($pluginDetails['data']['plugin_settings'], true);

    // load available extensions for this user
    $extType = 'non_media_types';
    if ($Auth->level_id == 1)
    {
        $extType = 'free_media_types';
    }
    elseif ($Auth->level_id > 1)
    {
        $extType = 'paid_media_types';
    }

    $ext = explode("|", $pluginSettings[$extType]);

    // check this is a video or audio, only 'mp4', 'webm', 'mp3', 'ogg' supported in this view
    if ((in_array(strtolower($file->extension), $ext) && (in_array(strtolower($file->extension), array('mp4', 'webm', 'mp3', 'ogg')))))
    {
		if ((int) $pluginSettings['show_embed'] == 1)
		{
			define("CONTROLS_HEIGHT", 40);
		?>
			<h4><strong><?php echo UCWords(t("embed_code", "embed code")); ?></strong></h4>
			<table class="table table-bordered table-striped">
				<tbody>
					<tr>
						<td class="share-file-table-header">
							<?php echo t('embed_video', 'Embed Video'); ?>:
						</td>
						<td class="responsiveTable ltrOverride">
							<section onClick="selectAllText(this); return false;">
								<?php
								// embed size
								$embedWidth = (int) $pluginSettings['embed_video_size_w'];
								$embedHeight = (int) $pluginSettings['embed_video_size_h'] + (int) CONTROLS_HEIGHT;
								if ($mediaPlayer == 'html5_audio')
								{
									$embedHeight = '109';
								}
								echo htmlentities('<iframe src="' . PLUGIN_WEB_ROOT . '/mediaplayer/site/_embed.php?u=' . $file->shortUrl . '&w=' . $pluginSettings['embed_video_size_w'] . '&h=' . $pluginSettings['embed_video_size_h'] . '" frameborder="0" scrolling="no" style="width: ' . $embedWidth . 'px; height: ' . $embedHeight . 'px; overflow: hidden;" webkitAllowFullScreen="true" mozallowfullscreen="true" allowFullScreen="true"></iframe>');
								?>
							</section>
						</td>
					</tr>
				</tbody>
			</table>
		<?php
		}
	}
}
?>