<?php
// initial constants
define('ADMIN_PAGE_TITLE', 'View Conversion Queue');
define('ADMIN_SELECTED_PAGE', 'view_queue');
define('ADMIN_SELECTED_SUB_PAGE', 'view_queue');

// includes and security
include_once('../../../core/includes/master.inc.php');
include_once(DOC_ROOT . '/' . ADMIN_FOLDER_NAME . '/_local_auth.inc.php');

// process submits
$file_short_urls = '';
$file_convert_type = 'video';
if(isset($_REQUEST['cancel']))
{
    $db->query('UPDATE plugin_mediaconverter_queue SET status = \'cancelled\' WHERE id='.(int)$_REQUEST['cancel'].' LIMIT 1');
    adminFunctions::setSuccess('Conversion job cancelled.');
}
elseif(isset($_REQUEST['redo']))
{
    $db->query('UPDATE plugin_mediaconverter_queue SET status = \'pending\' WHERE id='.(int)$_REQUEST['redo'].' LIMIT 1');
    adminFunctions::setSuccess('Conversion job re-scheduled.');
}
elseif(isset($_REQUEST['file_short_urls']))
{
	$file_short_urls 	= trim($_REQUEST['file_short_urls']);
	$file_convert_type 	= trim($_REQUEST['file_convert_type']);
	if(strlen($file_short_urls))
	{
		// load plugin details
		$pluginConfig   = pluginHelper::pluginSpecificConfiguration('mediaconverter');
		$pluginSettings = json_decode($pluginConfig['data']['plugin_settings'], true);
		$pluginObj = pluginHelper::getInstance('mediaconverter');
		
		// total stats
		$totalQueued = 0;
		$totalFailed = 0;
		$failedItems = array();
		
		// break apart to allow for multiple files
		$fileShortUrls = explode(",", $file_short_urls);
		foreach($fileShortUrls AS $fileShortUrl)
		{
			// load file
			$fileShortUrl = trim($fileShortUrl);
			$file = file::loadByShortUrl($fileShortUrl);
			if(!$file)
			{
				$totalFailed++;
				$failedItems[] = $fileShortUrl;
			}
			else
			{
				// check file type
				$fileTypes = explode(",", strtolower($pluginSettings['convert_files']));

				// make sure it's active and a video file
				if(($file->statusId == 1) && (in_array(strtolower($file->extension), $fileTypes)))
				{
					// inital params
					$convertVideo = true;
					$captureScreen = true;
					if($file_convert_type == 'screenshot')
					{
						$convertVideo = false;
					}
					
					// add to queue
					$rs = $pluginObj->scheduleForConverting($file, $convertVideo, $captureScreen);
					if($rs)
					{
						$totalQueued++;
					}
					else
					{
						$totalFailed++;
						$failedItems[] = $fileShortUrl;
					}
				}
				else
				{
					$totalFailed++;
					$failedItems[] = $fileShortUrl;
				}
			}
		}
		
		// output
		if($totalFailed > 0)
		{
			adminFunctions::setError('There was a problem adding '.$totalFailed.' item(s) to the queue, please try again later. If you submitted more items, these have been successfully added. Failed items:<br/><br/>'.implode(', ', $failedItems));
		}
		else
		{
			adminFunctions::setSuccess('Video(s) queued for conversion/screen capture.');
		}
	}
}

// overview stats
$totalPending = (int) $db->getValue("SELECT COUNT(id) AS total FROM plugin_mediaconverter_queue WHERE status = 'pending'");
$totalFailedLast3Days = (int) $db->getValue("SELECT COUNT(id) AS total FROM plugin_mediaconverter_queue WHERE status = 'pending' AND date_started BETWEEN NOW() - INTERVAL 3 DAY AND NOW()");
$totalConversions = (int) $db->getValue("SELECT COUNT(id) AS total FROM plugin_mediaconverter_queue WHERE status = 'completed'");
$totalConversionsLast3Days = (int) $db->getValue("SELECT COUNT(id) AS total FROM plugin_mediaconverter_queue WHERE status = 'completed' AND date_finished BETWEEN NOW() - INTERVAL 3 DAY AND NOW()");

// page header
include_once(ADMIN_ROOT.'/_header.inc.php');

// load all status
$statusDetails = array('pending', 'processing', 'completed', 'failed', 'cancelled');
?>

<script>
    oTable = null;
    gRewardId = null;
    $(document).ready(function(){
        // datatable
        oTable = $('#fileTable').dataTable({
            "sPaginationType": "full_numbers",
            "bServerSide": true,
            "bProcessing": true,
            "sAjaxSource": 'ajax/view_queue.ajax.php',
            "bJQueryUI": true,
            "iDisplayLength": 25,
            "aaSorting": [[ 1, "desc" ]],
            "aoColumns" : [   
                { bSortable: false, sWidth: '3%', sName: 'file_icon', sClass: "center adminResponsiveHide" },
                { sName: 'date_added', sWidth: '14%', sClass: "center dataTableFix" },
                { bSortable: false, sName: 'file', sClass: "adminResponsiveHide" },
                { bSortable: false, sName: 'convert_video', sWidth: '10%', sClass: "center adminResponsiveHide" },
				{ bSortable: false, sName: 'capture_screen', sWidth: '10%', sClass: "center adminResponsiveHide" },
				{ sName: 'status', sWidth: '11%', sClass: "center adminResponsiveHide" },
                { sName: 'date_started', sWidth: '14%', sClass: "center dataTableFix" },
                { bSortable: false, sWidth: '12%', sClass: "center" }
            ],
            "fnServerData": function ( sSource, aoData, fnCallback ) {
                aoData.push( { "name": "filterText", "value": $('#filterText').val() } );
                aoData.push( { "name": "filterByStatus", "value": $('#filterByStatus').val() } );
                $.ajax({
                    "dataType": 'json',
                    "type": "GET",
                    "url": "ajax/view_queue.ajax.php",
                    "data": aoData,
                    "success": fnCallback
                });
            }
        });
        
        // update custom filter
        $('.dataTables_filter').html($('#customFilter').html());
    });

    function reloadTable()
    {
        oTable.fnDraw();
    }
</script>

<div class="row clearfix">
    <div class="col_12">
        <div class="sectionLargeIcon" style="background: url(../assets/img/icons/128px.png) no-repeat;"></div>
        <div class="widget clearfix">
            <h2><?php echo adminFunctions::t('quick_overview', 'Quick Overview'); ?></h2>
            <div class="widget_inside">
                <div class="report">
                    <div class="button">
                        <span class="value"><?php echo $totalPending; ?></span>
                        <span class="attr">Pending Conversions</span>
                    </div>
                    <div class="button">
                        <span class="value"><?php echo $totalFailedLast3Days; ?></span>
                        <span class="attr">Failed Last 3 Days</span>
                    </div>
                    <div class="button">
                        <span class="value"><?php echo $totalConversions; ?></span>
                        <span class="attr">Total Completed</span>
                    </div>
                    <div class="button">
                        <span class="value"><?php echo $totalConversionsLast3Days; ?></span>
                        <span class="attr">Completed Last 3 Days</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row clearfix">
    <div class="widget clearfix">
        <h2>Converter Queue</h2>
        <div class="widget_inside responsiveTable">
            <?php echo adminFunctions::compileNotifications(); ?>
            <div class="col_12">
                <table id='fileTable' class='dataTable'>
                    <thead>
                        <tr>
                            <th></th>
                            <th><?php echo adminFunctions::t('date_added', 'Date Added'); ?></th>
                            <th class="align-left"><?php echo adminFunctions::t('file', 'File'); ?></th>
                            <th><?php echo adminFunctions::t('convert_video', 'Convert Video'); ?></th>
							<th><?php echo adminFunctions::t('capture_screen', 'Capture Screen'); ?></th>
							<th><?php echo adminFunctions::t('status', 'Status'); ?></th>
                            <th><?php echo adminFunctions::t('date_started', 'Date Started'); ?></th>
                            <th><?php echo adminFunctions::t('actions', 'Actions'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="row clearfix">
    <div class="col_12">
        <div class="widget clearfix">
            <h2>Manually Schedule Video Conversion</h2>
            <div class="widget_inside responsiveTable">
                <form method="POST" action="view_queue.php" name="userForm" id="userForm">
                    <div class="clearfix col_12">
                        <div class="col_4">
                            <h3>File Short Url</h3>
                            <p>Enter the file short url to manually add the video to the conversion queue. This will look similar to 'x2d3a'.</p>
                        </div>
                        <div class="col_8 last">
                            <div class="form">
                                <div class="clearfix alt-highlight">
                                    <label>Enter File Short Url(s):</label>
                                    <div class="input"><input id="file_short_urls" name="file_short_urls" type="text" class="xxlarge validate[required]" value="<?php echo adminFunctions::makeSafe($file_short_urls); ?>"/><br/><br/>Comma separate to add multiple. Max 500 at once.</div>
									
                                </div>
								<div class="clearfix">
                                    <label>Convertion Type:</label>
                                    <div class="input">
                                        <select name="file_convert_type" id="file_convert_type" class="xxlarge validate[required]" onChange="toggleConverterOptions(); return false;">
                                            <?php
                                            $options = array('video' => 'Convert Video &amp; Capture Screenshot', 'screenshot' => 'Capture Screenshot Only');
                                            foreach ($options AS $k => $option)
                                            {
                                                echo '<option value="' . $k . '"';
                                                if ($file_convert_type == $k)
                                                {
                                                    echo ' SELECTED';
                                                }
                                                echo '>' . $option . '</option>';
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
						
						<div class="col_4 adminResponsiveHide">&nbsp;</div>
                        <div class="col_8 last" style="margin-top: 14px;">
                            <div class="clearfix">
                                <div class="input no-label">
                                    <input type="submit" value="Schedule Conversion" class="button blue"/>
                                </div>
                            </div>
                        </div>
                    </div>

                    <input name="submitted" type="hidden" value="1"/>
                </form>
            </div>
        </div>   
    </div>
</div>

<div class="customFilter" id="customFilter" style="display: none;">
    <label>
        By Filename:
        <input name="filterText" id="filterText" type="text" onKeyUp="reloadTable(); return false;" style="width: 160px;"/>
    </label>
    <label class="adminResponsiveHide" style="padding-left: 6px;">
        By Status:
        <select name="filterByStatus" id="filterByStatus" onChange="reloadTable(); return false;" style="width: 120px;">
            <option value="">- all -</option>
            <?php
            if (COUNT($statusDetails))
            {
                foreach ($statusDetails AS $statusDetail)
                {
                    echo '<option value="' . $statusDetail . '"';
                    if (($filterByStatus) && ($filterByStatus == $statusDetail))
                    {
                        echo ' SELECTED';
                    }
                    echo '>' . UCWords(str_replace("_", " ", $statusDetail)) . '</option>';
                }
            }
            ?>
        </select>
    </label>
</div>

<?php
include_once(ADMIN_ROOT.'/_footer.inc.php');
?>