<?php

class validation
{
	// makes sure all content is made safe when outputted to screen
	static function safeOutputToScreen($input, $allowedChars = null, $length = null)
	{
		if ($allowedChars != null)
		{
			$input = self::removeInvalidCharacters($input);
		}

		if ($length != null)
		{
			if (strlen($input) > $length)
			{
				$input = substr($input, 0, $length - 3) . '...';
			}
		}

		$input = htmlspecialchars($input, ENT_QUOTES, "UTF-8");

		return $input;
	}

    // tests for a valid email address and optionally tests for valid MX records, too.
	static function validEmail($email)
	{
		if (preg_match("/^([_a-z0-9+-]+)(\.[_a-z0-9-]+)*@([a-z0-9-]+)(\.[a-z0-9-]+)*(\.[a-z]{2,4})$/i", $email))
		{
			return true;
		}

		return false;
	}
	
	static function validUsername($username)
	{
		return preg_match('/^[a-zA-Z0-9_]+$/', $username);
	}
	
	static function containsInvalidCharacters($input, $allowedChars = 'abcdefghijklmnopqrstuvwxyz 1234567890')
	{
		if (self::removeInvalidCharacters($input, $allowedChars) != $input)
		{
			return true;
		}

		return false;
	}

	static function removeInvalidCharacters($input, $allowedChars = 'abcdefghijklmnopqrstuvwxyz 1234567890')
	{
		$str = '';
		for ($i = 0; $i < strlen($input); $i++)
		{
			if (!stristr($allowedChars, $input[$i]))
			{
				continue;
			}

			$str .= $input[$i];
		}

		return $str;
	}
	
	static function validDate($date, $format = 'Y-m-d H:i:s')
	{
		$d = DateTime::createFromFormat($format, $date);

		return $d && $d->format($format) == $date;
	}
	
	static function validIPAddress($ipAddress)
	{
		if (preg_match("/^(([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]).){3}([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$/", $ipAddress))
		{
			return true;
		}
		return false;
	}
}
