//-----------------------------------------------------------------------------
// COPYRIGHT 2001 DELCAM PLC., BIRMINGHAM, ENGLAND. 
//-----------------------------------------------------------------------------
//
// History.
// Who When     What   
// --- -------- ---------------------------------------------------------------
// tpb 22/02/01 Written
//-----------------------------------------------------------------------------

// Looks after Lists stored in div's

//-------------------------------------------------------------------------------
// C O N S T R U C T O R
//
function SetupList(theList, maxHeight, emptyText)
{
  // We setup theList to have all the properties and actions of a list
  // We store all variables with the Div, 'expando' allows this! 
  theList.maxHeight = maxHeight;
  theList.emptyText = emptyText;

  // Setup callbacks for internal use
  theList.onclick    = ListOnClick;
  theList.ondblclick = ListOnClick; // Catch double clicks too!
  theList.onscroll   = ListOnScroll;
  theList.onkeydown  = ListOnKeyDown;
  theList.SelectLI   = ListSelectLI;
  theList.FindLI     = ListFindLI;

  theList.FindIdLI   = ListFindIdLI;

  // Function calls from outside
  theList.IsEmpty          = ListIsEmpty;
  theList.AddItem          = ListAddItem;
  theList.SelectItem       = ListSelectItem;
  theList.SelectItemWithId = ListSelectId;
  theList.DeleteItem       = ListDeleteItem;
  theList.UpdateItemName   = ListUpdateItemName;
  theList.UpdateItemData   = ListUpdateItemData;
  theList.Update2DCheck    = ListUpdate2DCheck;
  theList.Update3DCheck    = ListUpdate3DCheck;
  theList.GetSelectedName  = ListGetSelectedName;
  theList.GetSelectedData  = ListGetSelectedData;
  theList.DeleteAllItems   = ListDeleteAllItems;

  // Give this a UL that we will use to list items
  var ul = document.createElement("UL");
  ul.style.listStyleType = "none";
  ul.style.marginTop = "0px";
  ul.style.marginLeft = "0px";
  ul.style.marginRight = "0px";
  ul.style.marginBottom = "0px";
  //ul.style.width = "100%";
  //ul.style.height = "100%";
  theList.appendChild(ul);
  theList.ulID = ul;

  // Add the 'Empty' LI
  var li = document.createElement("LI");
  li.innerText=emptyText;  
  theList.ulID.appendChild(li);

  // Set 'selected' index
  theList.selIdx = 0;
}


//-------------------------------------------------------------------------------
// C A L L B A C K S
//
function ListOnKeyDown()
{
  // If the list is empty, do nothing
  if(this.IsEmpty())
    return;

  // Pick a new Index based on the key press
  var newIdx = this.selIdx;
  switch(event.keyCode)
  {
    case 38: newIdx--; break;
    case 40: newIdx++; break;
  }

  // Ensure the bounds are correct
  if(newIdx < 0)
    newIdx = 0;
  if(newIdx >= this.ulID.children.length)
    newIdx = this.ulID.children.length - 1;

  // Now select this one.
  this.SelectLI( this.ulID.children(newIdx) );
}

function ListOnClick()
{
  // If the list is empty, do nothing
  if(this.IsEmpty())
    return;

  var srcElem = event.srcElement;
  switch( srcElem.tagName )
  {
  // If it is an INPUT element and the great great great grandparent is a LI, toggle either the 2d or the 3d check
  case "INPUT":
    var item;
    for( item = srcElem.parentElement; item != null && item.tagName != "LI"; item = item.parentElement ); // Find the parent LI

    if( item != null ) // Then we have found the LI
    {
      switch( srcElem.id )
      {
      case "check2D": if( this.On2DClick != null ) this.On2DClick( item.innerText, item.data, srcElem.checked ); break;
      case "check3D": if( this.On3DClick != null ) this.On3DClick( item.innerText, item.data, srcElem.checked ); break;
      }
    }
    break;
  
  // If this is an LI we have clicked then we select it.
  case "LI": 
    this.SelectLI( srcElem );
    break;
  }
}

function ListOnScroll()
{
}

function ListSelectLI( item )
{
  // Deselect the currently selected object
  var oldItem = this.ulID.children(this.selIdx);  
  oldItem.style.borderColor = gBGColor;
  oldItem.style.backgroundColor = gBGColor;
  oldItem.style.color = gTextColor;

  // Find index of object we are selecting.
  var length = this.ulID.children.length;
  for(var i = 0; i < length; i++ )
    if( this.ulID.children(i) == item )
      this.selIdx = i;

  // Set this item to be selected
  item.style.borderColor = gSelTextColor;
  item.style.backgroundColor = gSelBGColor;
  item.style.color = gSelTextColor;

  // Make sure the object is scrolled into view
  item.scrollIntoView();

  // Call our preset event if defined.
  if( this.OnSelect != null )
    this.OnSelect( item.innerText, item.data );
}

function ListFindLI(name, data)
{
  // If the list is empty, do nothing

  if(this.IsEmpty())
    return false;

  var supplied_name = true;
  var supplied_data = true;

  if( name == null ) supplied_name = false;
  if( data == null ) supplied_data = false;

  // If both name and data specified find a double match in the UL children
  var length = this.ulID.children.length;
  if( supplied_name && supplied_data )
  {
    for(var i = 0; i < length; i++ )
    {
      var li = this.ulID.children(i);
      var text = li.innerText.replace(/[\f\n\r\t\v]*/, ""); // remove ANY whitespace except space
      if( text == name && li.data == data )
      {
        this.LastFindLIIdx = i;
        return li;
      }
    }
  }
  else if( supplied_name ) // Else check for name
  {
    for(var i = 0; i < length; i++ )
    {
      var li = this.ulID.children(i);
      var text = li.innerText.replace(/[\f\n\r\t\v]*/, ""); // remove ANY whitespace except space
      if( text == name )
      {
        this.LastFindLIIdx = i;
          return li;
      }
    }
  }
  else if(supplied_data) // Else check for data
  {
    for(var i = 0; i < length; i++ )
    {
      var li = this.ulID.children(i);
      if( li.data == data )
      {
        this.LastFindLIIdx = i;
          return li;
      }
    }
  }

  // Nothing found
  return false;
}

function ListFindIdLI(id)
{
  // If the list is empty, do nothing
  if(this.IsEmpty())
    return false;


  var length = this.ulID.children.length;

    for(var i = 0; i < length; i++ )
    {
      var li = this.ulID.children(i);
      if( li.data != null )
      {
        if (li.data.Id == id)
        {   
           this.LastFindLIIdx = i;
           return li;
        }
      }
    }

  // Nothing found
  return false;
}




//-------------------------------------------------------------------------------
// F U N C T I O N S
//
function ListIsEmpty()
{
  if(this.ulID.children.length <= 1 && this.ulID.children(0).data == null)
    return true; // List is empty
  return false; // Otherwise we have items in the list
}


//-------------------------------------------------------------------------------
// The following functions specify name and data to be stored with the item
// Select Delete and Update all search on either the name or data or both
// depending on what is passed into a function
// They wont do anything if they don't find a match.
//-------------------------------------------------------------------------------

function ListAddItem( name, data )
{
  if( name == null ) name = false;
  if( data == null ) data = false;

  // If the table is empty, remove...
  if( this.IsEmpty() && this.ulID.children.length == 1 )
    this.ulID.removeChild( this.ulID.children(0) );

  // Add an element to the list with the default styles
  var li = document.createElement("LI");
  this.ulID.appendChild(li);
  li.style.borderStyle = "dashed";
  li.style.borderColor = gBGColor;
  li.style.borderWidth = 1;
  li.style.backgroundColor = gBGColor;
  li.style.color = gTextColor;
  li.style.width = "100%";

  // Set the html including the two checkboxes - if a 'real' toolpath
  if (data.GetNumberOfSubToolpaths() == 0)
     {
     li.innerHTML = "<table cellspacing='0' cellpadding='0' border='0' align='right'><tr>"+
                    "<td><input type='checkbox' id='check2D'></td>" +
                    "<td><input type='checkbox' id='check3D'></td>" +
                    "</tr></table>" + name;
     }
  else
     {
     li.innerHTML = name;
     }
  // Store the data
  li.data = data;

  // Get the Checkboxes
  li.check2D = li.all.item("check2D");
  li.check3D = li.all.item("check3D");

  // Now select this li.
  this.SelectLI(li);

  // If this div is now too big then we apply the overflow
  if( this.offsetHeight > this.maxHeight )
  {
    this.style.overflow = "auto";
    this.style.height = this.maxHeight + "px";
    this.maxVisibleItems = this.ulID.children.length;
  }
}

function ListSelectItem(name, data)
{
  if( name == null ) name = false;
  if( data == null ) data = false;

  // Find the object we are trying to select
  var li = this.FindLI(name, data);

  if( li )
    this.SelectLI( li );
}

function ListSelectId(id)
{
  if (id == null)
     {
     return false;
     }
  // Find the object we are trying to select
  var li = this.FindIdLI(id);

  if ( li )
     {
     this.SelectLI( li );
     return true;
     }

  return false;
}


function ListDeleteItem(name, data)
{

  if( name == null ) name = false;
  if( data == null ) data = false;

  // Find the object we are trying to select


  var li = this.FindLI(name, data);
  if( li )
  {
    // We remove this from the list.
    this.ulID.removeChild( li );

    // Sort out selection problems
    if( this.ulID.children.length == 0 )
    {
      // Add the 'Empty' LI
      var li = document.createElement("LI");
      li.innerText = this.emptyText;  
      this.ulID.appendChild(li);

      // Set 'selected' index
      this.selIdx = 0;
    }
    else
    {
      if( this.selIdx >= this.LastFindLIIdx )
        this.selIdx--;
      // bem 23/02/2001 where getting -1 index when deleted first item in list
      if( this.selIdx < 0)
        this.selIdx = 0;

      this.SelectLI( this.ulID.children( this.selIdx ));
    }

    // Sort out the height
    // If this div is now too big then we apply the overflow
    //if( this.maxVisibleItems > this.ulID.children.length )
    //  {
    //  this.style.overflow = "none"; // Can't seem to set this back
    //  this.style.overflow = "auto"; // Can't seem to set this back
    //  }
  }
}

function ListUpdateItemName(name, data, newname)
{
  if( name == null ) name = false;
  if( data == null ) data = false;
  if( newname == null ) newname = false;

  // Find the object we are trying to select
  var li = this.FindLI(name, data);
  if( li )
  {
    // Set the new name
    li.innerText = newname;
  }
} 


function ListUpdateItemData(name, data, newdata)
{
  if( name == null ) name = false;
  if( data == null ) data = false;
  if( newdata == null ) newdata = false;

  // Find the object we are trying to select
  var li = this.FindLI(name, data);
  if( li )
  {
    // Set the new data
    li.data = newdata;
  }
} 

function ListUpdate2DCheck(name, data, check)
{
  //if( name == null ) name = false;
  //if( data == null ) data = false;
  //if( check == null ) check = false;

  // Find the object we are trying to select
  var li = this.FindLI(name, data);
  if( li )
  {
    // Set the check
    li.check2D.checked = check;
  }
  else
  {
    alert("failed to find toolpath " + data.Name());
  }
}

function ListUpdate3DCheck(name, data, check)
{
  //if( name == null ) name = false;
  //if( data == null ) data = false;
  //if( check == null ) check = false;

  // Find the object we are trying to select
  var li = this.FindLI(name, data);
  if( li )
  {
    // Set the check
    li.check3D.checked = check;
  }
}



function ListGetSelectedName()
{
  var item = this.ulID.children(this.selIdx);  
  return item.innerText;
}



function ListGetSelectedData()
{
  var item = this.ulID.children(this.selIdx);  
  return item.data;
}

function ListDeleteAllItems()
{
  // We delete the whole lot.
  this.innerHTML = ""; // Reset to nothing

  // Then reset it up!
  SetupList(this, this.maxHeight, this.emptyText);
}
