//=============================================================================
//
//@doc EXTERNAL
//
//@module SectionHeader.js   |  Javascript helper functions for section header roll-ups
//
// ----------------------------------------------------------------------------
// COPYRIGHT 2007 DELCAM PLC., BIRMINGHAM, ENGLAND. 
// ----------------------------------------------------------------------------
//
// History.
// Who When     What   
// --- -------- ---------------------------------------------------------------
// ejp 12/06/07 Written
//-----------------------------------------------------------------------------

//=== PromoteDivSectionHeader ===========================================
//
// 'Converts' a div tagged group into a section with header and roll-up 
// functionality.
//
// History
// Who When     What
// --- -------- ---------------------------------------------------------
// tpb 20/04/05 Written
//-----------------------------------------------------------------------
function PromoteDivSectionHeader(id)
{

}


//=== WriteSectionHeader ================================================
//
// write standard html used to create our fold up sections
//
// History
// Who When     What
// --- -------- ---------------------------------------------------------
// sic 25/09/07 Added this header.
//-----------------------------------------------------------------------

function WriteSectionHeader(div_id, title_text)
{
   var artcam = top.external;

   if (artcam.RetrieveString(document.title, div_id + 'Div', "show") == "hidden")
   {
      var imgSrc = artcam.HtmlRootDir + "../SharedImages/open_down_small_grey.gif";
      var visible = "none";
   }
   else
   {
      var imgSrc = artcam.HtmlRootDir + "../SharedImages/close_up_small_grey.gif";
      var visible = "";
   }

   document.write("<div id='" + div_id + "' style='padding-left:5px; background-color:" + artcam.GetSystemColourShadeString(COLOR_BTNFACE,2,COLOR_BTNSHADOW,1) + ";' OnClick='OnToggleClick(" + div_id + ")'>");
   document.write(  "<img id='" + div_id + "Img' src='" + imgSrc + "' align='right'>");
   document.write(  "<b>" + title_text + "</b>");
   document.write("</div>");
   document.write("<UL style='margin-left:3px'>");
   document.write(  "<span id='" + div_id + "Div' style='display:" + visible + ";'>");
}


//=== OnToggleClick ==============================================
//
//  Toggle displaying a particular group on the page
//

function OnToggleClick(headerDiv)
{
   var artcam = top.external;
   var state;
   var headerImg = document.getElementById(headerDiv.id + "Img");
   var childDiv = document.getElementById(headerDiv.id + "Div");

   if (childDiv.style.display != "none" )
      {
      childDiv.style.display = "none";
      headerImg.src = artcam.HtmlRootDir + '../SharedImages/open_down_small_grey.gif';
      state = "hidden";
      }
   else
      {
      // Make the div visible - we need to ensure that it is scrolled into view
      childDiv.style.display = "";
      headerImg.src = artcam.HtmlRootDir + '../SharedImages/close_up_small_grey.gif';
      // tpb 25/02/03 Ensure visible
      var obj = childDiv;
      var scrolltop = obj.offsetTop + obj.offsetHeight - document.body.offsetHeight + 5;
      if( document.body.scrollTop < scrolltop )
         document.body.scrollTop = scrolltop;
      state = "visible";
      }

   // store current setting in ArtCAM
   artcam.StoreString(window.document.title, childDiv.id, state);
}