//=============================================================================
//
//@doc EXTERNAL
//
//@module assistant.js   |  Javascript helper functions for assistant pages
//
// ----------------------------------------------------------------------------
// COPYRIGHT 2007 DELCAM PLC., BIRMINGHAM, ENGLAND. 
// ----------------------------------------------------------------------------
//
// History.
// Who When     What   
// --- -------- ---------------------------------------------------------------
// ejp 12/06/07 Written
//-----------------------------------------------------------------------------

//=== PromoteDivSectionHeader ===========================================
//
// 'Converts' a div tagged group into a section with header and roll-up 
// functionality.
//
// History
// Who When     What
// --- -------- ---------------------------------------------------------
// tpb 20/04/05 Written
//-----------------------------------------------------------------------
function PromoteDivSectionHeader(id)
{

}

   var toolbar_cache = artcam.GetToolbarData();

   // An array to hold a list of the tool selects for quicker updates.
   var tsArray = new Array();

   // A map of resource id to tool select object.
   var tsMapResourceToTs = new Object();

   function AddToolSelect(id)
   {
      document.write("<span id='" + id + "' onselect='OnToolClicked(" + id + ".GetSelectedData());'></span>");
      var ts = document.getElementById(id);
      PromoteToToolSelect(ts, "../SharedImages/");
      tsArray.push(ts);
      return ts;
   }

   function AddTool(ts, src, data, title)
   {
      // Should probably check that no entry exists before setting a new one.
      // Or we could use an array for each entry to hold a list of toolselects
      // with this tool.
      ts.AddItem(src, data, title);
      tsMapResourceToTs[data] = ts;
   }


   //=== AddSingleToolSelect ==============================================
   //
   // Added this helper to simplify the layout code for flyouts with a single entry.
   //
   // History
   // Who When     What
   // --- -------- ---------------------------------------------------------
   // ejp 27/10/05 Written
   //-----------------------------------------------------------------------

   function AddSingleToolSelect(id, icon_path, resource_id)
   {
      if (artcam.IsCommandLicensed(resource_id))
      {
         var ts = AddToolSelect(id);
         AddTool(ts, artcam.HtmlRootDir + icon_path, resource_id, artcam.GetCommandTooltip(resource_id));
         ts.Build();
         ts.SetSelectedIndex(0);
      }
   }

//=== OnToolStateChange ===================================
//
//  Called when the state of a tool changes.
//

function OnToolStateChange(resource_id, state)
{
   var ts = tsMapResourceToTs[resource_id];

   if (null != ts)
   {
      ts.UpdateItemByData(resource_id, state);
   }
}

//=== SetToolSelectItemStates ====================================
//
//  Called to update the enables/disabled states of the tools.
//

function SetToolSelectItemStates()
{
   var tsCount = tsArray.length;

   for (var ts = 0; ts < tsCount; ts++)
   {
      tsArray[ts].Refresh(toolbar_cache);
   }
}
