function plugin_main()
{
   if(!artcam.CurrentModel)
   {
      OnBackButton();
      return;
   }
         
   if (artcam.Relief == null)
      OnBackButton();
   
   var temp_relief = artcam.CreateEmptyRelief();
   if(temp_relief==null)
      OnBackButton();

   var assembly_draw_flag = artcam.ProjectAssembly.DrawFlag;
   if(!assembly_draw_flag)
      artcam.ProjectAssembly.DrawFlag = true;

   var limits_string = artcam.ProjectAssembly.VisibleLimits;
   var limits_array = new Array();
   limits_array = limits_string.split(",");
   if(limits_array.length!=6)
   {
      artcam.Alert("AssemblyVector::GetVisibleLimits returned " + limits_array.length + " arguments",0);
      return;
   }

   var MinX = parseFloat(limits_array[0]);
   var MinY = parseFloat(limits_array[1]);
   var MinZ = parseFloat(limits_array[2]);
   var MaxX = parseFloat(limits_array[3]);
   var MaxY = parseFloat(limits_array[4]);
   var MaxZ = parseFloat(limits_array[5]);

   var height = MaxY-MinY;
   var width = MaxX-MinX;
   var depth = MaxZ-MinZ;

   if( height <= 0 || width <= 0 || depth <= 0 )
   {
      artcam.MessageBox(gNoVisibleAssembly);
      OnBackButton();
      return;
   }

   var flat_height = height + (height/10);
   var flat_width = width + (width/10);
   var flat_depth = depth + (depth/10);

   var resolution = 30;
   temp_relief.Create(flat_height*resolution,flat_depth*resolution,flat_height,flat_depth,true);
   temp_relief.SetPosition(MinY,MinZ,0);

   // Silhouette View
   var transform_string = "0 0 0 1 1 1 90 -90 0 0 0 0 false";
   TransformObject(artcam.ProjectAssembly, transform_string, false);
   artcam.ProjectAssembly.RenderIntoRelief(temp_relief, true);
   TransformObject(artcam.ProjectAssembly, transform_string, true); // inverse transform

   artcam.VectorSelection.Selection = temp_relief.CreateVectorsAtHeight(0.1);
  
   artcam.VectorSelection.Move(GetRingSilhouetteCentre("x", false), GetRingSilhouetteCentre("y", false));

   var model_creation_page_name = artcam.CurrentModel.GetString("Ring_creation_page_name", "Failed");

   // No need to do this for ThreeAxis ring as the output is the same as above
   if(model_creation_page_name != "ThreeAxis")
   {
      temp_relief = GetReliefFromAssemblyTop(artcam.ProjectAssembly);
      temp_relief.ReplaceHeightsValues(9876543, temp_relief.BaseHeight);
      artcam.VectorSelection.Selection = temp_relief.CreateVectorsAtHeight(0.1);
   }
     
   if(!assembly_draw_flag)
      artcam.ProjectAssembly.DrawFlag = false;

   artcam.Refresh3dView();
   OnBackButton();
   return;
}

