function plugin_main()
{
   HideAllLibraryDivs();
   Write_params(paramsDiv);
   paramsDiv.style.display = "";
   globalStore.FlatPlane = FlatPlane;
   RestorePageSettings();
}

function Write_params(targetDiv)
{
   targetDiv.innerHTML = "";

   var hArr = new Array();
   WriteFormHelpSection(hArr);

   hArr.push("<table width='100%' border=0 cellspacing=0 style='margin-left:3px'>");
   hArr.push("<col width=40px><col width=70%><col width=30%>");
   hArr.push("<tr align=right><td><img src='JewelSmith/FlatPlane/Height.gif'></td><td>" + gHeight + ":</td><td align=left><input type=edit number size=3 value=0.0 id=HeightEdit></td></tr>");
   hArr.push("<tr align=right><td><img src='JewelSmith/FlatPlane/FromEdge.gif'></td><td>" + gFromEdge + ":</td><td align=left><input type=checkbox id=FromEdgeCheck></td></tr>");
   hArr.push("<tr HELPTAG><td colspan=3>"+ gHeightHelp +"</td></tr>");
   hArr.push("<tr align=right><td></td><td>" + gVerticalSides + ":</td><td align=left><input type=checkbox id=VerticalCheck></td></tr>");
   hArr.push("<tr HELPTAG><td colspan=3>"+ gVerticalSidesHelp +"</td></tr>");
   hArr.push("<tr align=right><td></td><td>" + gCutOut + ":</td><td align=left><input type=checkbox id=CutOutCheck></td></tr>");
   hArr.push("<tr HELPTAG><td colspan=3>"+ gCutOutHelp +"</td></tr>");
   hArr.push("</table>");

   hArr.push("<div class='mouseOut' button_name='forward_button' targetFunction='globalStore.FlatPlane' style='width=30px;float:right;'>");
   hArr.push("<img id=back_img src ='" + artcam.HtmlRootDir + "../SharedImages/accept.gif' align=absmiddle border=0 width=30 height=30>");
   hArr.push("</div>");

      // Add the back button HTML to the array
   AddBackButtonHTML(hArr);

   targetDiv.innerHTML += hArr.join("\n");

   // Bung all our HTML into the div and display it
   InitialiseButtonDivs();
   SubclassNumberEditControls();
   SetHelpSpanVisibility();

   globalStore.VerticalCheck = eval(VerticalCheck);
   globalStore.HeightEdit = eval(HeightEdit);
   globalStore.FromEdgeCheck = eval(FromEdgeCheck);
   globalStore.CutOutCheck = eval(CutOutCheck);
}

function FlatPlane()
{
   StorePageSettings();
   var ring_designer = artcam.CreateRingDesigner();
   if(ring_designer == null)
   {
      artcam.MessageBox(gUnlicensed);
      return;
   }

   if(artcam.VectorSelection.Count!=1)
   {
      artcam.MessageBox(gSingleVectorOnly);
      return;
   }

   SetRingDesignerInfoFromModel(ring_designer);

   var temp_relief = artcam.CreateEmptyRelief();
   if(temp_relief==null)
      return;

   ring_designer.plane_height = globalStore.HeightEdit.getValue();

   if(globalStore.FromEdgeCheck.checked)
      ring_designer.height_reference = 1;
   else
      ring_designer.height_reference = 0;

   temp_relief.CopyFromCurrent();
   artcam.MakeBackupRelief();
   artcam.EditCopy();
   artcam.EditPaste();

   ring_designer.RenderFlat(temp_relief, globalStore.VerticalCheck.checked);
   //artcam.FitArcsToSelection(0.001);

   // Put the selected vectors on the Corrected Vector Layer
   var layer_index = GetCorrectedVectorLayer();
   for( var idx=0; idx<artcam.VectorSelection.Count; idx++)
      artcam.VectorSelection.Item(idx).Layer = layer_index;

   if(globalStore.CutOutCheck.checked)
   {
      temp_relief.MergeLowestWithCurrent();
   }
   else
   {
      temp_relief.MergeHighestWithCurrent();
   }
   OnBackButton();
}

function RestorePageSettings()
{
   globalStore.CutOutCheck.checked = artcam.RetrieveInt("FlatPlane","CutOutCheck",0) == 1 ? true : false;
   globalStore.FromEdgeCheck.checked = artcam.RetrieveInt("FlatPlane","FromEdgeCheck",0) == 1 ? true : false;
   globalStore.VerticalCheck.checked = artcam.RetrieveInt("FlatPlane","VerticalCheck",0) == 1 ? true : false;
   globalStore.HeightEdit.setValue( artcam.RetrieveDouble("FlatPlane","HeightEdit",0));
}

function StorePageSettings()
{
   artcam.StoreInt("FlatPlane","CutOutCheck", globalStore.CutOutCheck.checked ? 1 :0);
   artcam.StoreInt("FlatPlane","FromEdgeCheck", globalStore.FromEdgeCheck.checked ? 1 :0);
   artcam.StoreInt("FlatPlane","VerticalCheck", globalStore.VerticalCheck.checked ? 1 :0);
   artcam.StoreDouble("FlatPlane","HeightEdit",globalStore.HeightEdit.getValue() );
}

