//=============================================================================
//
// Definition of the common types used by the tpmLibrary
//
// Who When     What
// --- -------- ---------------------------------------------------------------
// tpb 27/02/07 Created from tpmTypes.h
//-----------------------------------------------------------------------------

//@enum TPM_GroupType | Identifies what the group represents. e.g top face of male,
//                      bottom face of female, centre lines etc.
var TPM_GT_NO_GROUP      = -1; //@emem this has not benn defined as a tpm group
var TPM_GT_MALE_TOP      = 0;  //@emem group represents top edges of a male feature
var TPM_GT_MALE_BOTTOM   = 1;  //@emem group represents bottom edges of a male feature
var TPM_GT_FEMALE_TOP    = 2;  //@emem group represents top edges of a female feature
var TPM_GT_FEMALE_BOTTOM = 3;  //@emem group represents bottom edges of a female feature
var TPM_GT_CENTRELINE    = 4;  //@emem group is centre line machined
var TPM_GT_ROLLING_BALL  = 5;  //@emem group is a rolling ball centreline
var TPM_GT_HOLE          = 6;  //@emem group is a hole
var TPM_NUM_GROUP_TYPES  = 7;  //@emem place holder for number of group types

//@enum TPM_ToolpathDiffs | Identifies what has changed between two toolpaths
var TPM_TD_NO_DIFFS    = 0x0; //@emem no changes between toolpaths
var TPM_TD_MINOR_DIFFS = 0x1; //@emem minor changes between toolpaths (output moves still valid)
var TPM_TD_MAJOR_DIFFS = 0x2; //@emem major changes between toolpaths (output moves not valid)
var TPM_TD_INVALID     = 0x4; //@emem invalid changes between toolpaths

//@enum tpmERROR | error return codes for tpmLibrary
var tpmOK                          = 0; //@emem no error
var tpmMEMORY_ERROR                = 1; //@emem insufficient memory to perform operation
var tpmDUPLICATE_NAME_ERROR        = 2; //@emem attempt to add toolpath with same name as existing one
var tpmINVALID_NAME_ERROR          = 3; //@emem attempt to add toolpath with invalid name
var tpmNAME_NOT_FOUND_ERROR        = 4; //@emem toolpath with given name was not found
var tpmFILE_OPEN_ERROR             = 5; //@emem error opening file
var tpmFILE_READ_ERROR             = 6; //@emem error reading from file
var tpmFILE_WRITE_ERROR            = 7; //@emem error writing to file
var tpmGRAPHICS_ERROR              = 8; //@emem error occured while performing graphical operation
var tpmPP_MANAGER_ERROR            = 9; //@emem error occured while initialising toolpath manager
var tpmINVALID_PP_ERROR            = 10;//@emem invalid postp specified
var tpmTOOLPATH_CREATE_ERROR       = 11;//@emem error creating toolpath
var tpmTOOLPATH_SIMULATE_ERROR     = 12;//@emem error simulating toolpath
var tpmTOOLPATH_MANAGER_BUSY       = 13;//@emem duplicate command
var tpmUSER_CANCEL                 = 14;//@emem user cancelled operation
var tpmDIFFERENT_A_INDEXES_ERROR   = 15;//@emem toolpaths with different 'workplanes' in list


//@enum TPM_Strategy | types of 'main' strategy
var TPM_STRATEGY_INVALID       = -1;//@emem invalid (unititialised) value
var TPM_RASTER                 = 0; //@emem raster in x only
var TPM_RASTER_XY              = 1; //@emem raster in both x and y
var TPM_SPIRAL                 = 2; //@emem spiral upto limit of bounding box
var TPM_SPIRAL_BOX             = 3; //@emem spiral complete box with retracts
var TPM_MC_AREA                = 4; //@emem machine area defined by currently selected profiles 
var TPM_PROFILE                = 5; //@emem profile machine (feature machining)
var TPM_CUTOUT                 = 6; //@emem cut out pass
var TPM_MC_AREA_RASTER         = 7; //@emem machine specified area using raster
var TPM_MC_AREA_CLIMB          = 8; //@emem machine specified area using offsets and climb mill
var TPM_MC_AREA_CLIMB_CENTRE   = 9; //@emem machine specified area using offsets and climb mill from centre
var TPM_MC_AREA_CONV_CENTRE    = 10;//@emem machine specified area using offsets from centre
var TPM_CUSTOM_PATH            = 11;//@emem toolpath generated from custom drive pic etc

// The following are not in tpmTypes.h and are stored internally as TPM_CUSTOM_PATH
var TPM_DMK_3DOFFSET           = 1000;//@emem toolpath generated by dmkInterface
var TPM_DMK_3DOFFSET_SPIRAL    = 1001;//@emem toolpath generated by dmkInterface



//@enum TPM_Tool | types of tool
var TPM_TOOL_INVALID              = -1;//@emem invalid (unititialised) value
var TPM_BALL_NOSE                 = 0; //@emem ball nose tool
var TPM_SLOT_DRILL                = 1; //@emem slot drill 
var TPM_RADIUSED_SLOT             = 2; //@emem radiused slot drill
var TPM_CONICAL                   = 3; //@emem conical tool
var TPM_FLAT_CONICAL              = 4; //@emem conical tool with flat on end
var TPM_FLAT_RADIUSED_CONICAL     = 5; //@emem conical tool with radius and flat on end
var TPM_OGEE                      = 6; //@emem ogee tool
var TPM_ROMANOGEE                 = 7; //@emem ogee with reversed arcstool
var TPM_ROUNDOVER                 = 8; //@emem roundover
var TPM_RAISED_PANEL_OGEE         = 9; //@emem raised panel ogee
var TPM_RAISED_PANEL_COVE         = 10;//@emem raised panel cove
var TPM_RAISED_PANEL_STRAIGHT     = 11;//@emem raised panel straight
var TPM_DRILL_BANK                = 12;//@emem generic drill bank tool

//@enum TPM_Tolerance | tolerance settings
var TPM_TOLERANCE_INVALID       = -1;//@emem invalid (unititialised) value
var TPM_TOLERANCE_FINE          = 0; //@emem high tolerance (0.1 pixel)
var TPM_TOLERANCE_MEDIUM        = 1; //@emem medium tolerance (0.5 pixel)
var TPM_TOLERANCE_COARSE        = 2; //@emem low tolerance (1.0 pixel)
var TPM_TOLERANCE_CUSTOM        = 3; //@emem custom tolerance

//@enum TPM_FeedRateUnits | feedrate units
var TPM_FEEDRATE_UNITS_INVALID  = -1;//@emem invalid (unititialised) value
var TPM_MM_SEC                  = 0; //@emem mm/second
var TPM_MM_MIN                  = 1; //@emem mm/minute
var TPM_M_MIN                   = 2; //@emem m/minute
var TPM_INCH_SEC                = 3; //@emem inch/second
var TPM_INCH_MIN                = 4; //@emem inch/minute
var TPM_FEET_MIN                = 5; //@emem feet/min

//@enum TPM_ProfileMoves | controls profiling for raster toolpaths
var TPM_PM_NONE          = 0; //@emem no profiling moves
var TPM_PM_FIRST         = 1; //@emem profile before raster
var TPM_PM_LAST          = 2; //@emem profile after raster
var TPM_PM_DURING        = 3; //@emem profile during raster
   
// enum defining axis group that a drill belongs to
// For most drill bank machines its either X or Y, but could be extended.
// enum tpmDrillPositionAXIS_GROUP
var TPM_DRILL_AXIS_GROUP_UNKNOWN  = 0;
var TPM_DRILL_X_AXIS_GROUP1       = 0x0001;  // First X-axis group
var TPM_DRILL_Y_AXIS_GROUP1       = 0x0002;   // First Y-axis group
                                      // Might add second group for H patterns in the future
