//================================================================
//
// strategyObject.js   | Object which displays and manages an OA_Strategy
//                       object
//
//

// ----------------------------------------------------------------------------
// COPYRIGHT 2000 DELCAM PLC., BIRMINGHAM, ENGLAND. 
// ----------------------------------------------------------------------------
//
// History.
// Who When     What   
// --- -------- ---------------------------------------------------------
// bem 07/09/00 Created based on original ToolObject.js
// bem 25/05/01 Create inside a td
//-----------------------------------------------------------------------------


//=== Strategy Constructor ==============================================
//
// History
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 bem 07/09/00 Written
//-----------------------------------------------------------------------------

function Strategy
   (
   name,                   // name of object on page
   default_is_raster,      // true if default strategy is raster clearance - else offset
   changed_callback,       // optional callback if strategy changed (raster to/from offset only)
   show_raster,            // default is to show raster
   show_offset             // default is to show offset
   )
{
   // Assign Page Members
   this.name = name;

   // Assign Functions
   this.writeDiv        = Strategy_WriteDiv;
   this.initialise      = Strategy_Initialise;
   this.onStrategyRadio = Strategy_OnStrategyRadio;
   this.updateData      = Strategy_UpdateData;
   this.toggleHelp      = Strategy_ToggleHelp;
   this.updateGui		   = Strategy_UpdateGui;

   // has user chosen to display only 1 type ?
   if (show_raster != null)
      {
      this.showRasterOptions = show_raster;
      }
   else
      {
      this.showRasterOptions = true;
      }
   if (show_offset != null)
      {
      this.showOffsetOptions = show_offset;
      }
   else
      {
      this.showOffsetOptions = true;
      }
   
   if (!show_raster && default_is_raster)
      default_is_raster = false; 

   if (!this.showOffsetOptions && !this.showRasterOptions)
      {
      alert("Strategy: neither raster or offset visible !");
      this.showOffsetOptions = true;
      this.showRasterOptions = true;
      }

   if (this.showOffsetOptions && this.showRasterOptions)
      this.showOptions = true;
   else
      this.showOptions = false;


   this.strategy = artcam.Machining.CreateStrategyObject(default_is_raster);

   // is there a callback ?
   if (changed_callback == null)
      {
      this.doCallback = false;
      }
   else
      {
      this.updateCallback = changed_callback
      this.doCallback = true;
      }

   // get path to the root of our html - we use this to build
   // addresses to our images
   this.image_dir = artcam.HtmlRootDir();
   this.image_dir += "..\\SharedImages\\Strategy\\"

}


//=== Strategy_WriteDiv ==============================================
//
// History
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 bem 07/09/00 Written
//-----------------------------------------------------------------------------

function Strategy_WriteDiv()
{
   // This is a bit like create. We write all our document objects into the page
   // then show and hide them as we wish.

   document.writeln("<table cellspacing=0 border=0><tr>");
   document.writeln("   <td colspan=3><span class=BemHeading>" + gssStrategyText + "</span>&nbsp;&nbsp;&nbsp;");
if (this.showOptions)
   {
   document.writeln("   <input name='" + this.name + "StrategyRadio' onClick='javascript:" + this.name + ".onStrategyRadio()' type=radio CHECKED ></input><b>&nbsp;" + gssRasterText + "&nbsp;&nbsp;</b>");
   document.writeln("   <input name='" + this.name + "StrategyRadio' onClick='javascript:" + this.name + ".onStrategyRadio()' type=radio         ></input><b>&nbsp;" + gssOffsetText + " </b> </td>");
   }
else
   {
   document.writeln("</td>");
   }
   document.writeln("</tr>");
   document.writeln("<tr>");
   document.writeln("   <td colspan=3>");
   document.writeln("   <div id='div" + this.name + "Main'> ");

   // Raster strategy
   document.writeln("   <div id='div" + this.name + "RasterStrategy' style='DISPLAY: none'> ");
   document.writeln("      <table class=Dialog >");
   document.writeln("      <tr> ");
   document.writeln("         <td valign=top><IMG src='" + this.image_dir + "RasterStrategyIcon.gif' align=top></td>");
   document.writeln("         <td >");
   document.writeln("         <table  cellspacing=0 cellpadding=2 class=Dialog>");
   document.writeln("            <tr>");
   document.writeln("               <td ><IMG src='" + this.image_dir + "RasterAngle.gif' align=top></td>");
   document.writeln("               <td><b>" + gssAngleText + ":</b></td>");
   document.writeln("               <td ><input id='" + this.name + "RasterAngleEdit' number type=text size=3 maxLength=3></input>&nbsp;" + gssDegText + "</td></tr>");
   document.writeln("         </table>");
   document.writeln("            <tr>");
   document.writeln("               <td><IMG src='" + this.image_dir + "RasterProfile.gif' align=top></td>");
   document.writeln("               <td><b>" + gssProfilePassText + ":</b></td> ");
   document.writeln("            <tr>");
   document.writeln("               <td></td>");
   document.writeln("               <td><IMG src='" + this.image_dir + "RasterProfileNone.gif' align=top>&nbsp;<input name='" + this.name + "ProfileRadio' type=radio CHECKED></input>&nbsp;" + gssNoneText + "</td></tr>");
   document.writeln("               <td></td>");
   document.writeln("               <td ><IMG src='" + this.image_dir + "RasterProfileFirst.gif' align=top>&nbsp;<input name='" + this.name + "ProfileRadio' type=radio        ></input>&nbsp;" + gssFirstText + "</td></tr>");
   document.writeln("               <td></td>");
   document.writeln("               <td ><IMG src='" + this.image_dir + "RasterProfileLast.gif'  align=top>&nbsp;<input name='" + this.name + "ProfileRadio' type=radio        ></input>&nbsp;" + gssLastText + "</td></tr>");
   document.writeln("      </table>");
   document.writeln("  </div>");
   document.writeln("</tr>");

   
   // Offset strategy
   document.writeln("<tr>");
   document.writeln("   <td colspan=3>");
   document.writeln("   <div id='div" + this.name + "OffsetStrategy' style='DISPLAY: none'> ");
   document.writeln("      <table cellspacing=0 border=0>");
   document.writeln("         <tr>");
   document.writeln("         <td valign=top><IMG src='" + this.image_dir + "OffsetStrategyIcon.gif' align=top></td>");
   document.writeln("         <td>");
   document.writeln("            <table cellspacing=0 border=0>");
   document.writeln("               <tr><td valign=top><IMG src='" + this.image_dir + "OffsetCutDirection.gif' align = top></td>");
   document.writeln("                   <td valign=top><b>" + gssCutDirectionText + ":</b></td>");
   document.writeln("                      </td><td>");
   document.writeln("                      <table cellspacing=0 border=0>");
   document.writeln("                          <tr>");
   document.writeln("                            <td valign=top><input name='" + this.name + "CutDirectionRadio'  type=radio CHECKED ></input>&nbsp;" + gssClimbText + "</td>");
   document.writeln("                          </tr><tr>");
   document.writeln("                            <td valign=top><input name='" + this.name + "CutDirectionRadio'  type=radio         ></input>&nbsp;" + gssConventionalText + "</td>");
   document.writeln("                      </tr></table></td>");
   document.writeln("               </tr>");
   document.writeln("               <tr><td ><IMG src='" + this.image_dir + "OffsetStartFrom.gif' align = top></td>");
   document.writeln("                   <td><b>" + gssStartFromText + ":</b></td>");
   document.writeln("                   <td ><input name='" + this.name + "OffsetStartRadio'  type=radio CHECKED ></input>&nbsp;" + gssOutsideText + "</td></tr>");
   document.writeln("               <tr><td ></td>");
   document.writeln("                   <td ></td>");
   document.writeln("                   <td ><input name='" + this.name + "OffsetStartRadio'  type=radio         ></input>&nbsp;" + gssInsideText + "</td></tr>");
   document.writeln("            </table>");
   document.writeln("         </td>");
   document.writeln("      </table>");
   document.writeln("   </div>");
   document.writeln("   </td>");
   document.writeln("</td>");
   document.writeln("</tr>");

   // raster strategy help
   document.writeln("<tr HELPTAG style='display:none'>");
   document.writeln("   <td colspan=3>");
   document.writeln("   <div id='div" + this.name + "RasterStrategyHelp' style='DISPLAY: none'>");
   document.writeln("   <p>" + gssRasterStrategyHelp);
   document.writeln("   </div>");
   document.writeln("</tr>");

   // offset strategy help
   document.writeln("<tr HELPTAG style='display:none'>");
   document.writeln("   <td colspan=3>");
   document.writeln("   <div id='div" + this.name + "OffsetStrategyHelp' style='DISPLAY: none'>");
   document.writeln("   <p>" + gssOffsetStrategyHelp);
   document.writeln("   </div>");
   document.writeln("</tr>");
   document.writeln("</table>");

}



//=== Strategy_Initialise ==============================================
//
// History
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 bem 07/09/00 Written - Assigns object events to this object
//-----------------------------------------------------------------------------

function Strategy_Initialise()
{
   // Create members attached to the objects in our Div on the page.
   // This is done by evaluating the name that we called it when we wrote it in writeDiv
   // Since the object has this global name the evaluation returns the object
   // which we store in our object for convenience.
   // A bit like do data exchange in CDialog!

   this.mainDiv            = eval( "div" + this.name + "Main" ); 
   this.rasterStrategyDiv  = eval( "div" + this.name + "RasterStrategy" ); 
   this.offsetStrategyDiv  = eval( "div" + this.name + "OffsetStrategy" ); 

   this.rasterHelpDiv      = eval( "div" + this.name + "RasterStrategyHelp" ); 
   this.offsetHelpDiv      = eval( "div" + this.name + "OffsetStrategyHelp" ); 

if (this.showOptions)
   {
   this.strategyRadio      = eval( this.name + "StrategyRadio" );
   }
   this.rasterAngleEdit    = eval( this.name + "RasterAngleEdit" );
   this.profileRadio       = eval( this.name + "ProfileRadio" );
   this.cutDirectionRadio  = eval( this.name + "CutDirectionRadio" );
   this.offsetStartRadio   = eval( this.name + "OffsetStartRadio" );

   // display current values

   // raster or offset clearance ?
if (this.showOptions)
   {
   if (this.strategy.RasterStrategy)
      this.strategyRadio[0].checked = true
   else
      this.strategyRadio[1].checked = true
   }
   // raster angle
   this.rasterAngleEdit.value = this.strategy.RasterAngle;

   // raster profiling 0 - none, 1 profile first, 2 profile last , 3 - profile during
   switch(this.strategy.RasterProfilePass)
      {
      case 0:  // none 
           this.profileRadio[0].checked = true;
           break;
      case 1:  // first 
           this.profileRadio[1].checked = true;
           break;
      case 2:  // during
           this.profileRadio[2].checked = true;
           break;
      //case 3:  // last
      //     this.profileRadio[3].checked = true;
      //     break;
      default:
           alert("Unknown raster profile type");
      }

   // offset cutting direction climb / conventional
   if (this.strategy.ClimbMill)
      this.cutDirectionRadio[0].checked = true;
   else
      this.cutDirectionRadio[1].checked = true;

   // offset starting position - outside or centre
   if (this.strategy.CutFromCentre)
      this.offsetStartRadio[1].checked = true;
   else
      this.offsetStartRadio[0].checked = true;


   // set initial visibility options - they all default to inviisble
   if (this.strategy.RasterStrategy)
      {
      this.rasterStrategyDiv.style.display = "";
      this.rasterHelpDiv.style.display = "";
      }
   else
      {
      this.offsetStrategyDiv.style.display = ""
      this.offsetHelpDiv.style.display = "";
      }

} 



//=== Strategy_OnStrategyRadio ==============================================
//
// History
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 bem 07/09/00  Written - changes the available options
//-----------------------------------------------------------------------------

function Strategy_OnStrategyRadio()
{
if (this.showOptions)
   {
   if (this.strategyRadio[0].checked)
      {
      this.rasterStrategyDiv.style.display = ""
      this.offsetStrategyDiv.style.display = "none"
      this.strategy.RasterStrategy = true;
      if (artcam.DisplayHelp)
         {
         this.offsetHelpDiv.style.display = "none"
         this.rasterHelpDiv.style.display = ""
         }
      }
   else
      {
      // display offset parameters
      this.rasterStrategyDiv.style.display = "none"
      this.offsetStrategyDiv.style.display = ""
      this.strategy.OffsetStrategy = true;
      if (artcam.DisplayHelp)
         {
         this.offsetHelpDiv.style.display = ""
         this.rasterHelpDiv.style.display = "none"
         }
      }

   // update form this strategy is in
   if (this.doCallback)
      {
      this.updateCallback();
      }
   }
}


//=== Strategy_UpdateData ==============================================
//
// 
//

//
// History
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 bem 07/09/00 Written
//-----------------------------------------------------------------------------

function Strategy_UpdateData()
{

   // get current values from form - if we have a strategy object
   if (this.strategy == null)
      return false;

   // raster or offset clearance ?
   if (this.showOptions)
      {
      if (this.strategyRadio[0].checked)
         this.strategy.RasterStrategy = true;
      else
         this.strategy.OffsetStrategy = true;
      }
   // raster angle
   this.strategy.RasterAngle =  parseFloat(this.rasterAngleEdit.value);

   // raster profiling 0 - none, 1 profile first, 2 - profile last   
   if (this.profileRadio[0].checked)
      {
      this.strategy.RasterProfilePass = 0;
      }
   else if (this.profileRadio[1].checked)
      {
      this.strategy.RasterProfilePass = 1;
      }
   else if (this.profileRadio[2].checked)
      {
      this.strategy.RasterProfilePass = 2;
      }
   else
      {
      this.strategy.RasterProfilePass = 3;
      }


   // offset cutting direction climb / conventional
   if (this.cutDirectionRadio[0].checked)
      this.strategy.ClimbMill = true;
   else
      this.strategy.ConventionalMill = true;

   // offset starting position - outside or centre
   if (this.offsetStartRadio[0].checked)
      this.strategy.CutFromCentre = false;
   else
      this.strategy.CutFromCentre = true;

   return true;
}


// === Strategy_ToggleHelp =======================================
//
// Toggle display of our help
//

function Strategy_ToggleHelp()

{
// which 'help is displayed ?
if (this.strategy == null)
   {
   alert('strategy.toggleHelp called before strategy.initiliase');
   return;
   }

if ( this.strategy.RasterStrategy )
   ToggleVisibility(this.rasterHelpDiv);
else
   ToggleVisibility(this.offsetHelpDiv);

}
 

//=== Strategy_UpdateGui ==============================================
//
//  Regresh interface for passed strategy
//

//
// History
// Who When     What
// --- -------- ---------------------------------------------------------
// sap 18/04/01 Written
// bem 17/05/2001 
//-----------------------------------------------------------------------------

function Strategy_UpdateGui( new_strategy )
{

   // get current values from form - if we have a strategy object
   if (new_strategy == null)
      return false;

   // raster or offset clearance ?
   if (this.showOptions)
      {
      if (new_strategy.RasterStrategy )
          this.strategyRadio[0].checked = true;
      else
         this.strategyRadio[1].checked = true;
      }

   // raster angle
   this.rasterAngleEdit.value = new_strategy.RasterAngle;

   // raster profiling 0 - none, 1 profile first, 2 - profile last 3 - profile during (not used)  
   switch (new_strategy.RasterProfilePass )
     {
     case 0:
          this.profileRadio[0].checked = true;
          break;
     case 1:
          this.profileRadio[1].checked = true;
          break;
     case 2:
          this.profileRadio[2].checked = true;
          break;
     //case 3:
     //     this.profileRadio[3].checked = true;
     //     break;
     }

   // offset cutting direction climb / conventional
   if (new_strategy.ClimbMill)
       this.cutDirectionRadio[0].checked = true;
   else
      this.cutDirectionRadio[1].checked = true;

   // offset starting position - outside or centre
   if (new_strategy.CutFromCentre )
       this.offsetStartRadio[0].checked = false;
   else
      this.offsetStartRadio[0].checked = true;
   
   this.updateData();
   this.onStrategyRadio();

   return true;
}
