//================================================================
//
// MaterialObject.js   | Object which displays and manages access
//                       to ArtCAM's material setup
//
//

// ----------------------------------------------------------------------------
// COPYRIGHT 2000 DELCAM PLC., BIRMINGHAM, ENGLAND.
// ----------------------------------------------------------------------------
//
// History.
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 bem 07/09/00 Created based on original ToolObject.js
//-----------------------------------------------------------------------------


//=== Material Constructor ==============================================
//
// History
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 bem 07/09/00 Written
//-----------------------------------------------------------------------------

function Material
   (
   name,
   changed_callback
   )
{
   // Assign Page Members
   this.name = name;

   this.showThickness = true;
   this.showHR = true;


   // Assign Functions
   this.writeDiv     = Material_WriteDiv;
   this.initialise   = Material_Initialise;
   this.onSelect     = Material_OnSelect;
   this.updateData   = Material_UpdateData;
   //this.toggleHelp   = Material_ToggleHelp;
   this.onTerseClick = Material_OnTerseClick;

   this.materialDefined = false;
   this.minZ = 0.0;
   this.maxZ = 0.0;
   this.thickness = 0.0;

   // is there a callback ?
   if (changed_callback == null)
      {
      this.doCallback = false;
      }
   else
      {
      this.updateCallback = changed_callback
      this.doCallback = true;
      }

   // get path to the root of our html - we use this to build
   // addresses to our images
   this.image_dir = artcam.HtmlRootDir();
   this.image_dir += "..\\SharedImages\\Material\\"

}


//=== Material_WriteDiv ==============================================
//
// History
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 bem 07/09/00 Written
//-----------------------------------------------------------------------------

function Material_WriteDiv()
{
   // This is a bit like create. We write all our document objects into the page
   // then show and hide them as we wish.


   if(this.showHR)
   {
      document.writeln("<tr><td></td><td height=2px></td></tr>");
      document.writeln("<tr><td></td><td bgcolor=buttonshadow></td></tr>");
      document.writeln("<tr><td></td><td bgcolor=buttonhighlight></td></tr>");
      document.writeln("<tr><td></td><td height=2px></td></tr>");
   }

   document.writeln("<tr>");
   document.writeln("<td valign=top><IMG id='" + this.name + "MaterialLeftImage' src='" + this.image_dir + "/Material.gif' align = top></td>");

   document.writeln("<td> ");
   document.writeln("<table width=100% border=0 cellspacing=0>");
   document.writeln("<tr>");
   document.writeln("<td><span><b>" + gsmMaterialText + "</b></span></td>");
   document.writeln("<td align=right> <input type=button id='" + this.name + "SelectButton' value='Setup...' onClick=" + this.name + ".onSelect()> ");
   document.writeln("<tr bgcolor=" + artcam.GetSystemColourShadeString(COLOR_BTNFACE,2,COLOR_BTNSHADOW,1) + ">");
   document.writeln("<td colspan=2 onclick=" + this.name + ".onTerseClick()>");
   document.writeln("<img align=right id='" + this.name + "OpenCloseButton' src='" + this.image_dir + "..\\open_down_small_blue.gif' >");
   document.writeln("<span id='" + this.name + "SummarySpan'></span>");
   document.writeln("</td></tr></table></td></tr>");
   document.writeln("<tr>");
   document.writeln("   <td></td>");
   document.writeln("   <td>");
   document.writeln("      <div id='" + this.name +  "MainDiv' style='display:none'>");
   document.writeln("      <table class=Dialog border=0 id='"+ this.name + "MaterialTable'>");
   document.writeln("      <tr>");
   document.writeln("         <td align=right rowspan=4><IMG id='" + this.name + "MaterialImage' src='" + this.image_dir + "Material.gif'></td>");
   document.writeln("      </tr>");
   document.writeln("      <tr>");
   document.writeln("         <td>" + gsmZTopText + ":&nbsp;</td>");
   document.writeln("         <td><span id='" + this.name + "MaxZSpan'> </span></td>");
   document.writeln("      </tr>");
   document.writeln("      <tr>");
   document.writeln("         <td>" + gsmZBottomText + ":&nbsp;</td>");
   document.writeln("         <td><span id='" + this.name + "MinZSpan'> </span></td>");
   document.writeln("      </tr>");
   document.writeln("      <tr>");
   document.writeln("         <td>" + gsmOriginText + ":&nbsp;</td>");
   document.writeln("         <td><span id='" + this.name + "OriginSpan'> </span></td>");
   document.writeln("      </tr>");
   document.writeln("      </table>");
   document.writeln("      </div>");
   document.writeln("   </td>");
   document.writeln("</tr>");

   document.writeln("<tr HELPTAG style='display:none'>");
   document.writeln("   <td></td><td>");
   document.writeln("      <div id='div" + this.name + "Help'>");
   document.writeln("      <p>" + gsmMaterialHelp);
   document.writeln("      </div>");
   document.writeln("   </td>");
   document.writeln("</tr>");
   // change the text for the button
   eval(this.name + "SelectButton.value=gsmSetupText");


}



//=== Material_Initialise ==============================================
//
// History
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 bem 07/09/00 Written - Assigns object events to this object
//-----------------------------------------------------------------------------

function Material_Initialise()
{
   // Create members attached to the objects in our Div on the page.
   // This is done by evaluating the name that we called it when we wrote it in writeDiv
   // Since the object has this global name the evaluation returns the object
   // which we store in our object for convenience.
   // A bit like do data exchange in CDialog!

   this.mainDiv           = eval( this.name + "MainDiv" );
   if (this.showThickness)
      this.summarySpan    = eval( this.name + "SummarySpan" );
   this.maxZSpan          = eval( this.name + "MaxZSpan" );
   this.minZSpan          = eval( this.name + "MinZSpan" );
   this.originSpan        = eval( this.name + "OriginSpan" );
   this.materialHelpDiv   = eval( "div" + this.name + "Help" );

   this.materialImage     = eval( this.name + "MaterialImage" );
   this.materialLeftImage = eval( this.name + "MaterialLeftImage" );

   this.selectButton      = eval( this.name + "SelectButton" );

   this.OpenCloseButton  = eval( this.name + "OpenCloseButton");

   if(!artcam.MaterialDefined)
      this.OpenCloseButton.style.display='none';

   // display current values
   this.updateData();
}



//=== Material_OnSelect ==============================================
//
// History
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 bem 07/09/00  Written - Performs the selection
//-----------------------------------------------------------------------------

function Material_OnSelect()
{
// display the material setup box in ArtCAM

artcam.DoMaterialSetup();


this.updateData();


// update form this tool is in
if (this.doCallback)
   {
   this.updateCallback();
   }

for ( var i = 0 ; i < document.all.length ; i++ )
   {
   var matches = document.all[i].id.match( /(\w+)start_heightEdit/ );
   if ( matches != null )
      {
      var surface_z = artcam.MaterialMaxZ;
      if ( artcam.InMM() )
         surface_z += 1;
      else
         surface_z += 0.04;

      document.all[i].value = surface_z;
      }
   }
}


//=== Material_UpdateData ==============================================
//
//
//

//
// History
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 bem 07/09/00 Written
//-----------------------------------------------------------------------------

function Material_UpdateData()
{

   if ( artcam.MaterialDefined )
      {
      this.materialDefined = true;

      this.maxZ = artcam.MaterialMaxZ;
      this.minZ = artcam.MaterialMinZ;
      this.thickness = Math.abs(this.maxZ - this.minZ);

      // Get our Units
      var units = Units();

      // Set text
      if (this.showThickness)
         this.summarySpan.innerHTML = "<b>" + RoundUnits(this.thickness) + " " + units + "</b>";
      this.maxZSpan.innerText       = RoundUnits(this.maxZ)      + " " + units;
      this.minZSpan.innerText       = RoundUnits(this.minZ)      + " " + units;

      // set image indicating where origin is
      if (this.minZ < 0)
         {
         this.materialImage.src = this.image_dir + "/MaterialTopOrigin.gif"
         //this.materialLeftImage.src = this.image_dir + "/MaterialTopOrigin.gif"
         this.originSpan.innerText = gsmTopOfBlockText
         }
      else
         {
         this.materialImage.src    = this.image_dir + "/MaterialBottomOrigin.gif"
         //this.materialLeftImage.src    = this.image_dir + "/MaterialBottomOrigin.gif"
         this.originSpan.innerText = gsmBottomOfBlockText
         }

      this.OpenCloseButton.style.display='';
      }
   else  // we have no material or relief
      {
      this.materialDefined = false;
      this.maxZ = 0.0;
      this.minZ = 0.0;
      this.thickness = 0.0;

      // Set the example text to warn user that there is no relief
      if (this.showThickness)
         this.summarySpan.innerHTML = "<font color=red>" + gsmUndefinedText + "</font>";
      this.maxZSpan.innerHTML    = "<font color=red>" + gsmUndefinedText + "</font>";
      this.minZSpan.innerHTML    = "<font color=red>" + gsmUndefinedText + "</font>";
      this.originSpan.innerHTML  = "<font color=red>" + gsmUndefinedText + "</font>";
      this.materialImage.src     = this.image_dir + "/NoMaterial.gif";
      //this.materialLeftImage.src     = this.image_dir + "/NoMaterial.gif";
      this.OpenCloseButton.style.display='none';
      return false;
      }

return true;
}

// === Material_ToggleHelp =======================================
//
// Toggle display of our help
//
// ejp 14/03/02 No longer needed

//function Material_ToggleHelp()

//{
//ToggleVisibility(this.materialHelpDiv);
//}

//=== Tool_OnTerseClick ==============================================
//
// History
// DICC  Who When     What
// ----- --- -------- ---------------------------------------------------------
// 00000 tpb 11/02/00 Written
//-----------------------------------------------------------------------------

function Material_OnTerseClick()
   {
   // if the material tool is 'undefined' we cant display details
   if (!artcam.MaterialDefined)
      {
      this.mainDiv.style.display = "none";
      // hide the up/down button and text as well
      this.OpenCloseButton.style.display = "none";
      return;
      }

   // if we reach here we have material defined
   this.OpenCloseButton.style.display = "";

   // Toggle the visibility!
   if(this.mainDiv.style.display == "none" )
      {
      this.mainDiv.style.display = "";
      this.OpenCloseButton.src = this.image_dir + "..\\close_up_small_blue.gif";
      this.OpenCloseButton.border = 0;
      }
   else
      {
      this.mainDiv.style.display = "none";
      this.OpenCloseButton.src = this.image_dir + "..\\open_down_small_blue.gif";
      this.OpenCloseButton.border = 0;
      }
   }



