//================================================================
//
// cutDirectionObject.js   
//
// Object which displays and manages cut direction
//
//

// ----------------------------------------------------------------------------
// COPYRIGHT 2001 DELCAM PLC., BIRMINGHAM, ENGLAND. 
// ----------------------------------------------------------------------------
//
// History.
// Who When     What   
// --- -------- ---------------------------------------------------------
// bem 24/05/2001 Written
//-----------------------------------------------------------------------------


//=== cutDirection Constructor ==============================================
//
// History
// Who When     What
// --- -------- ---------------------------------------------------------
// bem 24/05/2001 Written
// bem 12/08/2002 Modified to save / restore default cutting direction
//-----------------------------------------------------------------------------

function CutDirection
   (
   name,
   changed_callback 
   )
{
   // Assign Page Members
   this.name = name;

   //this.do_climb_mill = true;
   this.do_climb_mill = artcam.RetrieveInt("ToolSettings","DefaultCutDirection",1) == 1 ? true : false;


   // Assign Functions
   this.writeDiv		         = cutDirection_WriteDiv;
   this.initialise		      = cutDirection_Initialise;
   this.onToggleTerse         = cutDirection_onCutDirectionTerseClick;
   this.updateDisplay         = cutDirection_UpdateCutDirectionDisplay;
   this.onTypeRadioClick      = cutDirection_OnTypeRadioClick;
   
   this.updateParametersFromToolpath = cutDirection_UpdateParametersFromToolpath;
   this.saveParametersToToolpath     = cutDirection_SaveParametersToToolpath;

   // is there a callback ?
   if (changed_callback == null)
      {
      this.doCallback = false;
      }
   else
      {
      this.updateCallback = changed_callback
      this.doCallback = true;
      }

   // get path to the root of our html - we use this to build
   // addresses to our images
   this.image_dir = artcam.HtmlRootDir();
   this.image_dir += "..\\SharedImages\\CutDirection\\";

}

//=== cutDirection_WriteDiv ==============================================
//
// Writes out the html which is the interface for the cut direction
// control into any toolpath dialog
//
// History
// Who When     What
// --- -------- ---------------------------------------------------------
// bem 24/05/2001 Written
//-----------------------------------------------------------------------------

function cutDirection_WriteDiv()
{
   // This is a bit like create. We write all our document objects into the page
   // then show and hide them as we wish.

   document.writeln("<table width=100% cellspacing=0 border=0>");
   document.writeln("<tr><td height=2px></td></tr>");
   document.writeln("<tr><td bgcolor=buttonshadow></td></tr>");
   document.writeln("<tr><td bgcolor=buttonhighlight></td></tr>");
   document.writeln("<tr><td height=2px></td></tr>");
   document.writeln("     <tr bgcolor=" + artcam.GetSystemColourShadeString(COLOR_BTNFACE,2,COLOR_BTNSHADOW,1) + ">");
   document.writeln("     <td colspan=2 onclick='" + this.name + ".onToggleTerse()'>");
   document.writeln("         <img align=right id='" + this.name + "jCutDirectionOpenCloseButton' src= '" + this.image_dir + "../open_down_small_blue.gif' >");
   document.writeln("         <b><script>w(gCutDirectionText)</script>:&nbsp;</b><span id='" + this.name + "jCutDirectionTerseSpan'></span>&nbsp&nbsp");
   document.writeln("       </td>");
   document.writeln("     </tr>");
   document.writeln("     <tr id='" + this.name + "jCutDirectionTableDiv' style='display:none'>");
   document.writeln("     <td colspan=2 >");
   document.writeln("       <table cellspacing=0 border=0>");
   document.writeln("           <tr>");
   document.writeln("             <td width=50%>");
   document.writeln("                 <img src='" + this.image_dir + "ClimbMill.gif' border=0>");
   document.writeln("             </td>");
   document.writeln("             <td>");
   document.writeln("                 <img src='" + this.image_dir + "ConventionalMill.gif'>");
   document.writeln("             </td>");
   document.writeln("           </tr>");
   document.writeln("           <tr>");
   document.writeln("             <td>");
   document.writeln("               <input name='" + this.name + "jCutDirectionRadio' onClick='" + this.name + ".onTypeRadioClick()' type=radio CHECKED ></input>&nbsp;<b><script>w(gClimbMillText)</script></b>");
   document.writeln("             </td>");
   document.writeln("             <td>");
   document.writeln("               <input name='" + this.name + "jCutDirectionRadio' onClick='" + this.name + ".onTypeRadioClick()' type=radio  ></input>&nbsp;<b><script>w(gConventionalMillText)</script></b>");
   document.writeln("             </td>");
   document.writeln("           </tr>");
   document.writeln("           <tr HELPTAG style='display:none'>");
   document.writeln("             <td colspan=2>");
   document.writeln("               <script>w(gCutDirectionHelp)</script>");
   document.writeln("             </td>");
   document.writeln("           </tr>");
   document.writeln("       </table>");
   document.writeln("       </td>");
   document.writeln("    </tr>");
   document.writeln("</table>");

}


//=== cutDirection_Initialise ==============================================
//
// History
// Who When       What
// --- ---------- ---------------------------------------------------------
// bem 25/05/2001 Written
//-----------------------------------------------------------------------------

function cutDirection_Initialise()
{
   // Set up members for the data controls
   this.cutDirectionTableDiv	      = eval( this.name + 'jCutDirectionTableDiv');
   this.cutDirectionOpenCloseButton = eval( this.name + 'jCutDirectionOpenCloseButton');
   this.cutDirectionRadio           = eval( this.name + 'jCutDirectionRadio');
   this.cutDirectionTerseSpan       = eval( this.name + 'jCutDirectionTerseSpan');


   this.updateDisplay();
} 


// === cutDirection_UpdateParametersFromToolpath ===================================
//
// Update ramp parameters from passed toolpath
//
// History
// Who When       What
// --- ---------- ---------------------------------------------------------
// bem 21/05/2001 Written
// ----------------------------------------------------------------------

function cutDirection_UpdateParametersFromToolpath(toolpath)
{
   if (toolpath == null)
      return;

   var climb_mill = toolpath.GetFlag('ClimbMill',this.do_climb_mill);

//alert(climb_mill);
   if ( climb_mill )
      {
      this.cutDirectionRadio[0].checked = true;
      this.cutDirectionRadio[1].checked = false;
      }
   else
      {
      this.cutDirectionRadio[0].checked = false;
      this.cutDirectionRadio[1].checked = true;
      } 
   this.do_climb_mill = this.cutDirectionRadio[0].checked;
   this.updateDisplay();
}

// === cutDirection_SaveParametersToToolpath ===================================
//
// Save ramp parameters to passed toolpath
//
// History
// Who When       What
// --- ---------- ---------------------------------------------------------
// bem 21/05/2001 Written
// ----------------------------------------------------------------------

function cutDirection_SaveParametersToToolpath(toolpath)
{
   if (toolpath == null)
      return;

   toolpath.SetFlag('ClimbMill',this.do_climb_mill);

}


// === cutDirection_OnTypeRadioClick =======================================
//
// Called when user toggles use of circular arc lead ins
//
function cutDirection_OnTypeRadioClick()
{
   this.do_climb_mill = this.cutDirectionRadio[0].checked;
   this.updateDisplay();
}

// === cutDirection_onCutDirectionTerseClick =========================
//
// Toggle display of cut direction details
//
function cutDirection_onCutDirectionTerseClick()
{
ToggleVisibility( this.cutDirectionTableDiv );

if (this.cutDirectionTableDiv.style.display != 'none')
   this.cutDirectionOpenCloseButton.src= this.image_dir + '../close_up_small_blue.gif'
else
   this.cutDirectionOpenCloseButton.src= this.image_dir + '../open_down_small_blue.gif'

}


// === cutDirection_UpdateCutDirectionDisplay ============================
//
// Set details for cut direction
//

function cutDirection_UpdateCutDirectionDisplay()
{
   if (this.do_climb_mill)
      {
      this.cutDirectionTerseSpan.innerText = gClimbMillText;
      this.cutDirectionRadio[0].checked = true;
      }
   else
      {
      this.cutDirectionTerseSpan.innerText= gConventionalMillText;
      this.cutDirectionRadio[1].checked = true;
      }

   if (this.cutDirectionTableDiv.style.display != 'none')
      this.cutDirectionOpenCloseButton.src= this.image_dir + '../close_up_small_blue.gif'
   else
      this.cutDirectionOpenCloseButton.src= this.image_dir + '../open_down_small_blue.gif'

}
