// Calling page must have paramsDiv & libraryDiv objects for these functions
// show and manipulate

function plugin_main()
{
   HideAllLibraryDivs();
   paramsDiv.innerHTML = "";

   globalStore.ActiveShank = new Shank();
   globalStore.ActiveShank.DefaultName = gDefaultFilename;
   globalStore.ActiveShank.UseForwardButton = false;
   globalStore.ActiveShank.WriteParamsHTML(paramsDiv);
   globalStore.ActiveShank.CallbackFunction = OnCreateBlank;
   return;
}

function OnCreateBlank(completed)
{
   if(!completed)
   {
      OnBackButton();
      return;
   }

   // IE7 Workaround.
   // ---------------
   // In the code below, we were calling artcam.CreateNewModel, which in turn called
   // a script function on this page 'FileCheck' in GeneralTools.js. This function resets the location
   // of this page so that it is due for reload. A problem occurs, because straight after, we call
   // SaveArtFile which throws up a message box. This messagebox has a message pump, which allows
   // messages to get to the IE window. This allows the IE window to get on with reloading the page,
   // BEFORE the Save function call returns to the page. When this function finally does return, there
   // is no page and IE7 complains. This is probably due to a more serious security restriction in IE7
   // that IE6 let us get away with.
   //
   // Our simplest way around this issue it to hide the FileCheck function during Open, then
   // to call it AFTER any GUI has been shown. In this way, the page wont reload unexpectedly.
   // Then we call FileCheck afterwards.
   //
   // Temporarily Store FileCheck Function and set it to a function that does nothing.
   var FileCheckHolder = FileCheck;
   FileCheck = function() {/*Do Nothing*/}

   //   Create the model and save it
   if (true == CreateThreeAxisShankFromShankObjectVert(globalStore.ActiveShank))
   {
      artcam.CurrentModel.SetString("ringinfo_size_description", globalStore.ActiveShank.Description);
      SaveArtFile("Shank", globalStore.ActiveShank.NameEdit.value);
   }

   // Restore FileCheck and call it
   FileCheck = FileCheckHolder;
   FileCheck();

   OnCloseAndGotoAssistantTab();
   OnBackButton();
}
