// Calling page must have paramsDiv & libraryDiv objects for these functions
// show and manipulate
// ejp 14/02/08 - Removed options that have been replaced by direct control through the project tree item:
//                Renaming, Visibility, Ring Properties, Associated File, Accept & Back buttons.
//                Added a section to report inner diameter if the object is a shank - still potentially useful
//                for settings etc. as it returns distance of nearest triangle vertex to world centre.

function plugin_main()
{
   HideAllLibraryDivs();

   paramsDiv.style.display = "";

   // Create the parameters in paramsDiv (this must exist)
   Write_paramsDiv();

   // Initialise any button classes we have just created
   InitialiseButtonDivs();
   
   // if help is NOT visible turn it off
   if (artcam.DisplayHelp)
      ToggleHelp();
}

function Write_paramsDiv()
{
   // Empty any existing content
   paramsDiv.innerHTML = "";

   // Create an array to hold the HTML
   var hArr = new Array();
   hArr.push("<table border=0 cellspacing=0 cellpadding=1 width=100% style='padding-left:3px;text-align:justify'>");
   //hArr.push("<colgroup><col width = 40px><col width = 20%> <col width = 20% > <col width = 60% ></colgroup>");
   hArr.push("<tr HELPTAG style='DISPLAY:none'><td colspan=3><img src='../SharedImages/help.gif'>" + gAttributesHelp + "</td></tr>");
   hArr.push("<tr style='text-align:left'><td><img src='../SharedImages/info.gif'></td><td>" + gRingProperties +":</td><td id=RingPropertiesTD></td></tr>");
   hArr.push("<tr HELPTAG style='DISPLAY:none'><td colspan=3>" + gRingPropertiesHelp + "</td></tr>");
   hArr.push("<tr style='text-align:left'><td rowspan=3><img src='../SharedImages/JewelSmith/Shankicon.gif'></td><td><font color = 'red'>" + gWidth +":</font></td><td id=WidthTD></td></tr>");
   hArr.push("<tr style='text-align:left'><td><font color = 'green'>" + gLength +":</font></td><td id=LengthTD></td></tr>");
   hArr.push("<tr style='text-align:left'><td><font color = 'blue'>" + gHeight +":</font></td><td id=HeightTD></td></tr>");
   hArr.push("<tr HELPTAG style='DISPLAY:none'><td colspan=3>" + gDimensionsHelp + "</td></tr>");
   hArr.push("<tr><td></td><td>" + gVolume +":</td><td><input type=edit number size=8 id=VolumeEdit readonly=true style='background-Color:buttonface;border:0' >mm<sup>3</sup></td></tr>");
   hArr.push("<tr><td></td><td>" + gMaterial + ":</td><td><div id=MaterialSelect onselect='globalStore.OnMaterialSelect()' style='width:120px'></div></td></tr>");
   hArr.push("<tr><td></td><td>" + gShrinkage + ":</td><td><input type=edit id='ShrinkageEdit' onkeyup='globalStore.OnShrinkageEdit()' number size=5 maxLength=6 dp='3'>%</td></tr>");
   hArr.push("<tr><td></td><td><b>" + gWeight +":</b></td></tr>");
   hArr.push("<tr><td></td><td align=right><input type=edit number size=5 id=WeightEdit readonly=true style='background-Color:buttonface;border:0'></td>");
   hArr.push("<td><div id=WeightUnitSelect onselect='globalStore.OnWeightUnitSelect()' style='width:120px;'></div></td></tr>");
   hArr.push("<tr><td></td><td colspan=2><input type=checkbox id=ContainsSlicedSTL onClick = 'globalStore.OnJewelCADModelCheck()'><label for='ContainsSlicedSTL'>" + gContainsSlicedSTL +"</label></td></tr>");
   hArr.push("<tr HELPTAG style='DISPLAY:none'><td colspan=3>" + gContainsSlicedSTLHelp + "</td></tr>");

   hArr.push("</table>");

   // Bung all our HTML into the div and display it
   paramsDiv.innerHTML = hArr.join("\n");
   SubclassNumberEditControls();
   PromoteDivToSelect(MaterialSelect);
   PromoteDivToSelect(WeightUnitSelect);

   globalStore.ContainsSlicedSTL = eval(ContainsSlicedSTL);
   globalStore.RingPropertiesTD = eval(RingPropertiesTD);
   globalStore.WidthTD = eval(WidthTD);
   globalStore.HeightTD = eval(HeightTD);
   globalStore.LengthTD = eval(LengthTD);
   
   globalStore.VolumeEdit = eval(VolumeEdit);
   globalStore.MaterialSelect = eval(MaterialSelect);
   globalStore.OnMaterialSelect = OnMaterialSelect;
   globalStore.WeightUnitSelect = eval(WeightUnitSelect);
   globalStore.OnWeightUnitSelect = OnWeightUnitSelect;
   globalStore.OnShrinkageEdit = OnShrinkageEdit;
   globalStore.WeightEdit = eval(WeightEdit);
   globalStore.WeightEdit.setValue(0);
   
   globalStore.OnJewelCADModelCheck = OnJewelCADModelCheck;

   globalStore.Density = 1;
   globalStore.WeightRatio = 1;
   
   // Find distance to the nearest triangle from world centre   
   var distance = artcam.SelectedAssembly.FindHoleRadius(0,0,0,0,true);
      
   if( distance > 0.01)
   {
      globalStore.RingPropertiesTD.innerHTML = '<b><i>' + Round(distance,3) + ' (' + Round(distance*2,3) + ')</i></b>';
   }
   else
      globalStore.RingPropertiesTD.innerHTML = '<i>' + gNone + '</i>';

   globalStore.VolumeEdit.setValue(GetVolume(artcam.SelectedAssembly));

   var fso = artcam.CreateFileSystemObject();
   if(fso == null)
   {
      artcam.MessageBox("Unable to create FileSystemObject!");
      return;
   }

   // Set file in Custom directory by default...
   // Densities
   var file_path = artcam.HtmlRootDir + "../MaterialDensities/Densities.txt";
   if(fso.FileExists(artcam.HtmlLangDir + "JewelSmith/MaterialDensities/Densities.txt"))
   {
      file_path = artcam.HtmlLangDir + "JewelSmith/MaterialDensities/Densities.txt";
   }
   FillSelectFromTextPairFile(globalStore.MaterialSelect, file_path);

   // WeightUnits
   file_path = artcam.HtmlRootDir + "../MaterialDensities/WeightUnits.txt";
   if(fso.FileExists(artcam.HtmlLangDir + "JewelSmith/MaterialDensities/WeightUnits.txt"))
   {
      file_path = artcam.HtmlLangDir + "JewelSmith/MaterialDensities/WeightUnits.txt";
   }
   FillSelectFromTextPairFile(globalStore.WeightUnitSelect, file_path);

   if(artcam.SelectedAssembly.FlagExists('ContainsSlicedSTL'))
   {
      globalStore.ContainsSlicedSTL.checked = artcam.SelectedAssembly.GetFlag('ContainsSlicedSTL', false);
   }
   else
      globalStore.ContainsSlicedSTL.checked = false;

   RetrievePageSettings();
   OnWeightUnitSelect();
   OnMaterialSelect();
   GetDimensions();
   paramsDiv.style.display = "";
}

function GetVolume(assembly)
{
   var volume=0;
   for(var index=0; index<assembly.NumChildren;index++)
   {
      var child_assembly = assembly.GetChildAtIndex(index);
      volume += GetVolume(child_assembly);
   }

   for(var index=0; index<assembly.Num3dModels;index++)
   {
      var model = assembly.Get3dModelAtIndex(index);
      volume += model.Volume;
   }
   return volume;
}

function OnMaterialSelect()
{
   var values = globalStore.MaterialSelect.GetSelectedData();
   var value_array = values.split(",");
   var cost;

   switch(value_array.length)
   {
   case 1:
      globalStore.Density = value_array[0];
      break;
   case 2:
      globalStore.Density = value_array[0];
      cost = value_array[1];
      break;
   }
   UpdateWeight();
   artcam.StoreInt("AssemblyProperties", "MaterialSelectIndex",  globalStore.MaterialSelect.GetSelectedIndex() );
}

function UpdateWeight()
{
   var volume = VolumeEdit.getValue();

   // Adjust the volume by the shrinkage
   var shrinkage_scale = 100.0 / (100.0 + ShrinkageEdit.getValue()) ;
   var shrinkage_scale_cubed = shrinkage_scale * shrinkage_scale * shrinkage_scale;
   artcam.Alert("shrinkage_scale_cubed: " + shrinkage_scale_cubed, 0);
   volume *= shrinkage_scale_cubed;

   var weight = volume * (globalStore.Density / 1000.0);
   weight *= globalStore.WeightRatio;
   globalStore.WeightEdit.setValue(weight);
}

function OnWeightUnitSelect()
{
   var values = globalStore.WeightUnitSelect.GetSelectedData();
   var value_array = values.split(",");

   switch(value_array.length)
   {
   case 1:
      globalStore.WeightRatio = value_array[0];
      break;
   }
   UpdateWeight();
   artcam.StoreInt("AssemblyProperties", "WeightUnitSelectIndex",  globalStore.WeightUnitSelect.GetSelectedIndex() );
}

function OnShrinkageEdit()
{
   UpdateWeight();
   artcam.StoreString("AssemblyProperties","Shrinkage",ShrinkageEdit.getValue());  
}

function RetrievePageSettings()
{
   var index = artcam.RetrieveInt("AssemblyProperties", "WeightUnitSelectIndex", 0);
   globalStore.WeightUnitSelect.SetSelectedIndex(index);

   index = artcam.RetrieveInt("AssemblyProperties", "MaterialSelectIndex", 0);
   globalStore.MaterialSelect.SetSelectedIndex(index);

   ShrinkageEdit.setValue(artcam.RetrieveString("AssemblyProperties","Shrinkage","0.0"));
}

function OnJewelCADModelCheck()
{
   artcam.SelectedAssembly.SetFlag('ContainsSlicedSTL', globalStore.ContainsSlicedSTL.checked);
   artcam.ProjectAssembly.UpdateAssemblyMonitor();
}

function GetDimensions()
{
   artcam.SelectedAssembly.UpdateBoundingBox();

var width = artcam.SelectedAssembly.MaxX - artcam.SelectedAssembly.MinX;
var length = artcam.SelectedAssembly.MaxY - artcam.SelectedAssembly.MinY;
var height = artcam.SelectedAssembly.MaxZ - artcam.SelectedAssembly.MinZ;

globalStore.WidthTD.innerHTML = '<b><i>' + Round(width,3) + '</i></b>';
globalStore.LengthTD.innerHTML = '<b><i>' + Round(length,3) + '</i></b>';
globalStore.HeightTD.innerHTML = '<b><i>' + Round(height,3) + '</i></b>';

}